/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Element;

class ElementParser {
    protected final StartElement startElement;
    protected final XMLEventReader eventReader;
    protected final XMLEventFactory eventFactory;

    ElementParser(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) {
        this.startElement = startElement;
        this.eventReader = eventReader;
        this.eventFactory = eventFactory;
    }

    Element parse(Element.Builder builder) throws XMLStreamException {
        int inlineNestingDepth = 0;
        builder.setStartElement(this.startElement);
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(this.startElement.getName())) {
                ++inlineNestingDepth;
            }
            if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                if (0 < inlineNestingDepth) {
                    builder.addInnerEvent(event);
                    --inlineNestingDepth;
                    continue;
                }
                builder.setEndElement(event.asEndElement());
                builder.setEventFactory(this.eventFactory);
                return builder.build();
            }
            builder.addInnerEvent(event);
        }
        throw new IllegalStateException("Unexpected structure");
    }
}

