/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Comparator;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeComparatorOnTagType;
import net.sf.okapi.common.resource.CodeMatches;
import net.sf.okapi.common.resource.TextFragment;

public class CodeComparatorOnIsolated
implements Comparator<Code> {
    public static final CodeComparatorOnTagType CMP_TAG_TYPE = new CodeComparatorOnTagType();
    private final CodeMatches codematches;
    private final boolean matchIsolatedOnly;
    private int index;
    private int fromIndex;

    public CodeComparatorOnIsolated(CodeMatches codeMatches) {
        this(codeMatches, true);
    }

    public CodeComparatorOnIsolated(CodeMatches codeMatches, boolean matchIsolatedOnly) {
        this.codematches = codeMatches;
        this.matchIsolatedOnly = matchIsolatedOnly;
    }

    public void setToIndex(int index) {
        this.index = index;
    }

    public void setFromIndex(int index) {
        this.fromIndex = index;
    }

    @Override
    public int compare(Code c1, Code c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null || c2 == null) {
            return -1;
        }
        boolean isC1Isolated = this.codematches.isToIsolated(this.index);
        boolean isC2Isolated = this.codematches.isFromIsolated(this.fromIndex);
        if (this.matchIsolatedOnly) {
            if (isC1Isolated && isC2Isolated || !isC1Isolated && !isC2Isolated) {
                return 0;
            }
        } else {
            boolean tagTypeMatch;
            boolean bl = tagTypeMatch = CMP_TAG_TYPE.compare(c1, c2) == 0;
            if (tagTypeMatch) {
                return 0;
            }
            if (c1.getTagType() == TextFragment.TagType.PLACEHOLDER && isC2Isolated) {
                return 0;
            }
            if (c2.getTagType() == TextFragment.TagType.PLACEHOLDER && isC1Isolated) {
                return 0;
            }
        }
        return -1;
    }
}

