/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String WRITE_ALL_PROPERTIES_AS_ATTRIBUTES = "writeAllPropertiesAsAttributes";
    private static final String ENABLE_DUPLICATE_PROPS = "enableDuplicateProps";
    private static final String PROP_VALUE_SEP = "PROP_VALUE_SEP";
    private static final String GENERATE_TU_UUID = "GENERATE_TU_UUID";
    private static final String AUTOGENERATE_TU_ID = "AUTOGENERATE_TU_ID";
    private static final String NORMALIZE_INLINE_IDS = "NORMALIZE_INLINE_IDS";

    @Override
    public void reset() {
        super.reset();
        this.setWriteAllPropertiesAsAttributes(false);
        this.setEnableDuplicateProps(false);
        this.setPropValueSep(", ");
        this.setGenerateUUID(false);
        this.setAutoGenerateTuId(true);
        this.setNormalizeInlineIDs(false);
    }

    public boolean isWriteAllPropertiesAsAttributes() {
        return this.getBoolean(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES);
    }

    public void setEnableDuplicateProps(boolean duplicateProps) {
        this.setBoolean(ENABLE_DUPLICATE_PROPS, duplicateProps);
    }

    public boolean isEnableDuplicateProps() {
        return this.getBoolean(ENABLE_DUPLICATE_PROPS);
    }

    public void setWriteAllPropertiesAsAttributes(boolean writeAllPropertiesAsAttributes) {
        this.setBoolean(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES, writeAllPropertiesAsAttributes);
    }

    public String getPropValueSep() {
        return this.getString(PROP_VALUE_SEP);
    }

    public void setPropValueSep(String sep) {
        this.setString(PROP_VALUE_SEP, sep);
    }

    public boolean isGenerateUUID() {
        return this.getBoolean(GENERATE_TU_UUID);
    }

    public void setGenerateUUID(boolean generateUUID) {
        this.setBoolean(GENERATE_TU_UUID, generateUUID);
    }

    public boolean isAutoGenerateTuId() {
        return this.getBoolean(AUTOGENERATE_TU_ID);
    }

    public void setAutoGenerateTuId(boolean autoGenerateTuId) {
        this.setBoolean(AUTOGENERATE_TU_ID, autoGenerateTuId);
    }

    public boolean isNormalizeInlineIDs() {
        return this.getBoolean(NORMALIZE_INLINE_IDS);
    }

    public void setNormalizeInlineIDs(boolean normalizeInlineIDs) {
        this.setBoolean(NORMALIZE_INLINE_IDS, normalizeInlineIDs);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES, "Write all text unit level properties as TMX attributes", null);
        desc.add(ENABLE_DUPLICATE_PROPS, "Expand out duplicate property values into individual elements", null);
        desc.add(PROP_VALUE_SEP, "Separator string used to delimit duplicate property values", null);
        desc.add(GENERATE_TU_UUID, "Generate a UUID instead of an auto generated id or existing name", null);
        desc.add(AUTOGENERATE_TU_ID, "Auto-generate TU ID if missing", null);
        desc.add(NORMALIZE_INLINE_IDS, "Start inline code ids at 1 for each segment", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("TMX Filter Writer Options", true, false);
        desc.addCheckboxPart(paramsDesc.get(WRITE_ALL_PROPERTIES_AS_ATTRIBUTES));
        desc.addCheckboxPart(paramsDesc.get(ENABLE_DUPLICATE_PROPS));
        desc.addTextInputPart(paramsDesc.get(PROP_VALUE_SEP));
        desc.addCheckboxPart(paramsDesc.get(AUTOGENERATE_TU_ID));
        desc.addCheckboxPart(paramsDesc.get(GENERATE_TU_UUID));
        desc.addCheckboxPart(paramsDesc.get(NORMALIZE_INLINE_IDS));
        return desc;
    }
}

