/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class POEncoder
implements IEncoder {
    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
    }

    @Override
    public void reset() {
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (context != EncoderContext.TEXT) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            builder.append(this.encode(ch, context));
        }
        return builder.toString();
    }

    @Override
    public String encode(char value, EncoderContext context) {
        if (context != EncoderContext.TEXT) {
            return String.valueOf(value);
        }
        switch (value) {
            case '\\': {
                return "\\\\";
            }
            case '\"': {
                return "\\\"";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\u000b': {
                return "\\v";
            }
            case '\b': {
                return "\\b";
            }
            case '\u0007': {
                return "\\a";
            }
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            return new String(Character.toChars(value));
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        if ("approved".equals(propertyName)) {
            if (value != null && value.equals("no")) {
                return "fuzzy";
            }
            return "";
        }
        return value;
    }

    @Override
    public String getLineBreak() {
        return "\n";
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public String getEncoding() {
        return "";
    }
}

