/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.Objects;
import net.sf.okapi.common.resource.TextPart;

public class Range {
    public int start;
    public int end;
    public String id;
    public TextPart part;

    public Range(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public Range(int start, int end, String id) {
        this.start = start;
        this.end = end;
        this.id = id;
    }

    public boolean contains(int pos) {
        return pos >= this.start && pos <= this.end;
    }

    public boolean contains(Range range) {
        return this.contains(range.start) && this.contains(range.end);
    }

    public boolean intersectsWith(Range range) {
        return this.contains(range.start) || this.contains(range.end);
    }

    public String toString() {
        return String.format("(%d,%d,%s)", this.start, this.end, this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.start == range.start && this.end == range.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

