/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.ttxsplitter.TTXSplitter;
import net.sf.okapi.steps.ttxsplitter.TTXSplitterParameters;

@UsingParameters(value=TTXSplitterParameters.class)
public class TTXSplitterStep
extends BasePipelineStep {
    private TTXSplitterParameters params = new TTXSplitterParameters();
    private TTXSplitter splitter;

    @Override
    public String getDescription() {
        return "Splits a TTX document into several ones of roughly equal word count. Expects: raw document. Sends back: raw document.";
    }

    @Override
    public String getName() {
        return "TTX Splitter";
    }

    @Override
    public TTXSplitterParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (TTXSplitterParameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.splitter = new TTXSplitter(this.params);
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        URI uri = rawDoc.getInputURI();
        if (uri == null) {
            throw new OkapiBadStepInputException("TTX Splitter expects a URI input.");
        }
        this.splitter.split(uri);
        return event;
    }
}

