/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.steps.tokenization.Token;
import net.sf.okapi.steps.tokenization.TokenConfigs;

public class Tokens
extends ArrayList<Token> {
    private static final TreeMap<Integer, TokenConfigs.TokenConfig> idMap;
    private static final TreeMap<String, TokenConfigs.TokenConfig> nameMap;
    private static final TokenConfigs configs;

    public static int getTokenIndex(String tokenName) {
        if (nameMap == null) {
            return 0;
        }
        TokenConfigs.TokenConfig c = nameMap.get(tokenName);
        return configs.indexOf(c) + 1;
    }

    public static int getTokenId(String tokenName) {
        if (nameMap == null) {
            return -1;
        }
        TokenConfigs.TokenConfig c = nameMap.get(tokenName);
        return c != null ? c.getId() : -1;
    }

    public static String getTokenName(int tokenId) {
        if (idMap == null) {
            return "";
        }
        TokenConfigs.TokenConfig c = idMap.get(tokenId);
        return c != null ? c.getName() : "";
    }

    public static String getTokenDescription(int tokenId) {
        if (idMap == null) {
            return "";
        }
        TokenConfigs.TokenConfig c = idMap.get(tokenId);
        return c != null ? c.getDescription() : "";
    }

    public static String getTokenDescription(String tokenName) {
        if (nameMap == null) {
            return "";
        }
        TokenConfigs.TokenConfig c = nameMap.get(tokenName);
        return c != null ? c.getDescription() : "";
    }

    public static String getTokenNamesStr() {
        if (nameMap == null) {
            return "";
        }
        return ListUtil.arrayAsString(nameMap.keySet().toArray(new String[0]));
    }

    public static Collection<TokenConfigs.TokenConfig> getRules() {
        if (idMap == null) {
            return null;
        }
        return idMap.values();
    }

    public static List<String> getTokenNames() {
        return new ArrayList<String>(nameMap.keySet());
    }

    public static List<Integer> getTokenIDs() {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (String tokenName : nameMap.keySet()) {
            idList.add(Tokens.getTokenId(tokenName));
        }
        return idList;
    }

    public static List<Integer> getTokenIDs(List<String> tokenNames) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        if (tokenNames != null) {
            for (String tokenName : tokenNames) {
                idList.add(Tokens.getTokenId(tokenName));
            }
        }
        return idList;
    }

    public Tokens getFilteredList(String ... tokenNames) {
        if (tokenNames == null || tokenNames.length == 0) {
            return this;
        }
        List<String> names = Arrays.asList(tokenNames);
        Tokens res = new Tokens();
        for (int i = 0; i < this.size(); ++i) {
            Token token = (Token)this.get(i);
            if (token == null || !names.contains(token.getName())) continue;
            res.add(token);
        }
        return res;
    }

    public Tokens getExcludedFilteredList(String ... tokenNames) {
        if (tokenNames == null || tokenNames.length == 0) {
            return this;
        }
        List<String> names = Arrays.asList(tokenNames);
        Tokens res = new Tokens();
        for (int i = 0; i < this.size(); ++i) {
            Token token = (Token)this.get(i);
            if (token == null || names.contains(token.getName())) continue;
            res.add(token);
        }
        return res;
    }

    public void fixRanges(List<Integer> markerPositions) {
        for (Integer pos : markerPositions) {
            for (Token token : this) {
                if (token.getRange().start > pos) {
                    token.getRange().start += 2;
                }
                if (token.getRange().end <= pos) continue;
                token.getRange().end += 2;
            }
        }
    }

    @Override
    public String toString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Token token : this) {
            res.add(token.toString());
        }
        return ListUtil.listAsString(res, "\n");
    }

    static {
        configs = new TokenConfigs();
        idMap = new TreeMap();
        nameMap = new TreeMap();
        configs.loadFromResource(TokenConfigs.TokenConfig.class, "/token_types.tprm");
        for (TokenConfigs.TokenConfig c : configs) {
            if (c == null) continue;
            idMap.put(c.getId(), c);
            nameMap.put(c.getName(), c);
        }
    }
}

