/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String REMOVE_LEADING_TRAILING_CODES = "removeLeadingTrailingCodes";
    private static final String MERGE_CODES = "mergeCodes";
    private static final String RULES = "rules";

    @Override
    public void reset() {
        super.reset();
        this.setRemoveLeadingTrailingCodes(true);
        this.setMergeCodes(true);
        this.setRules(null);
    }

    public void setRemoveLeadingTrailingCodes(boolean removeLeadingTrailingCodes) {
        this.setBoolean(REMOVE_LEADING_TRAILING_CODES, removeLeadingTrailingCodes);
    }

    public boolean getRemoveLeadingTrailingCodes() {
        return this.getBoolean(REMOVE_LEADING_TRAILING_CODES);
    }

    public void setMergeCodes(boolean mergeCodes) {
        this.setBoolean(MERGE_CODES, mergeCodes);
    }

    public boolean getMergeCodes() {
        return this.getBoolean(MERGE_CODES);
    }

    public String getRules() {
        return this.getString(RULES);
    }

    public void setRules(String rules) {
        this.setString(RULES, rules);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(REMOVE_LEADING_TRAILING_CODES, "Remove leading and trailing codes", "Removes leading and trailing codes from the source and place them in the skeleton.");
        desc.add(MERGE_CODES, "Merge codes", "Merges adjacent codes (leading/trailing codes are removed first (if option is enabled)).");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Inline Codes Simplifier", true, false);
        desc.addCheckboxPart(paramsDesc.get(REMOVE_LEADING_TRAILING_CODES));
        desc.addCheckboxPart(paramsDesc.get(MERGE_CODES));
        return desc;
    }
}

