/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.yaml.Parameters;
import net.sf.okapi.filters.yaml.YamlEncoder;
import net.sf.okapi.filters.yaml.YamlEventBuilder;
import net.sf.okapi.filters.yaml.YamlSkeletonWriter;
import net.sf.okapi.filters.yaml.parser.IYamlHandler;
import net.sf.okapi.filters.yaml.parser.Key;
import net.sf.okapi.filters.yaml.parser.Line;
import net.sf.okapi.filters.yaml.parser.ParseException;
import net.sf.okapi.filters.yaml.parser.Scalar;
import net.sf.okapi.filters.yaml.parser.StreamProvider;
import net.sf.okapi.filters.yaml.parser.TokenMgrException;
import net.sf.okapi.filters.yaml.parser.YamlNodeTypes;
import net.sf.okapi.filters.yaml.parser.YamlParser;
import net.sf.okapi.filters.yaml.parser.YamlScalarTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class YamlFilter
extends AbstractFilter
implements IYamlHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String YAML_SCALAR_TYPE_PROPERTY_NAME = "Scalar Type";
    public static final String YAML_PARENT_INDENT_PROPERTY_NAME = "Parent Scalar Indent";
    public static final String YAML_SCALAR_FLOW_PROPERTY_NAME = "Scalar Flow";
    private static final String WHITESPACE_REGEX = "[ \t\r\n\f\u200b\f]+";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[ \t\r\n\f\u200b\f]+");
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private Parameters params;
    private YamlEventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private IFilter subFilter;
    private Stack<Key> keyStack;
    private YamlNodeTypes currentNodeType;
    private Key currentKey;
    private Pattern exceptions;
    private int subfilterIndex;
    private RawDocument input;
    private YamlParser parser;
    private int extraIndent;

    public YamlFilter() {
        this.setMimeType("text/x-yaml");
        this.setName("okf_yaml");
        this.setDisplayName("YAML Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), "text/x-yaml", this.getClass().getName(), "YAML", "YAML files", null, ".yml;.yaml"));
        this.setParameters(new Parameters());
        this.setFilterWriter(this.createFilterWriter());
    }

    @Override
    public void close() {
        super.close();
        this.hasUtf8Bom = false;
        this.hasUtf8Encoding = false;
        if (this.input != null) {
            this.input.close();
        }
        if (this.keyStack != null) {
            this.keyStack.clear();
        }
        this.currentNodeType = YamlNodeTypes.UNKNOWN;
        this.currentKey = null;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        return this.eventBuilder.next();
    }

    @Override
    public void open(RawDocument input) {
        this.currentNodeType = YamlNodeTypes.UNKNOWN;
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        String subFilterName;
        this.input = input;
        super.open(input, generateSkeleton);
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        String encoding = detector.getEncoding();
        String linebreak = detector.getNewlineType().toString();
        this.hasUtf8Bom = detector.hasUtf8Bom();
        this.hasUtf8Encoding = detector.hasUtf8Encoding();
        input.setEncoding(encoding);
        this.setEncoding(encoding);
        this.setNewlineType(linebreak);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), encoding, generateSkeleton);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", encoding), e);
        }
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.exceptions = Util.isEmpty(this.params.getExceptions()) ? null : Pattern.compile(this.params.getExceptions());
        if (this.eventBuilder == null) {
            this.eventBuilder = new YamlEventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setMimeType("text/x-yaml");
        this.eventBuilder.setPreserveWhitespace(true);
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
            this.eventBuilder.setCodeFinder(this.params.getCodeFinder());
        }
        if (!this.params.getUseCodeFinder() && !Util.isEmpty(subFilterName = this.params.getSubfilter())) {
            this.subFilter = this.getFilterConfigurationMapper().createFilter(subFilterName, this.subFilter);
            if (this.subFilter != null) {
                this.subFilter.setFilterConfigurationMapper(this.getFilterConfigurationMapper());
            }
        }
        this.subfilterIndex = 0;
        this.keyStack = new Stack();
        this.currentKey = null;
        this.parser = new YamlParser(new StreamProvider(reader));
        this.parser.setHandler(this);
        try {
            this.parser.parse();
        }
        catch (ParseException | TokenMgrException e) {
            throw new OkapiBadFilterInputException(String.format("Error parsing YAML file: %s", e.getMessage()), e);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
        this.createSkeletonWriter();
        this.getEncoderManager();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = super.getEncoderManager();
            this.encoderManager.setMapping("text/x-yaml", "net.sf.okapi.filters.yaml.YamlEncoder");
            this.encoderManager.setDefaultOptions(this.getParameters(), this.getEncoding(), this.getNewlineType());
        }
        this.encoderManager.setOptions(this.getParameters(), this.getEncoding(), this.getNewlineType());
        this.encoderManager.updateEncoder("text/x-yaml");
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new YamlSkeletonWriter(this.params.isWrap());
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    public void handleStart() {
        this.setFilterWriter(this.createFilterWriter());
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
    }

    @Override
    public void handleEnd() {
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
        this.keyStack.clear();
        this.currentNodeType = YamlNodeTypes.UNKNOWN;
        this.currentKey = null;
    }

    @Override
    public void handleComment(String c, boolean insideScalar) {
        if (c == null) {
            return;
        }
        this.eventBuilder.addToDocumentPart(c);
    }

    @Override
    public void handleKey(Key key) {
        this.extraIndent = 0;
        this.eventBuilder.addToDocumentPart(key.key);
        key.nodeType = this.currentNodeType;
        this.currentKey = key;
        this.keyStack.push(this.currentKey == null ? new Key() : this.currentKey);
    }

    @Override
    public void handleWhitespace(String whitespace, boolean isInsideScalar) {
        if (whitespace == null) {
            return;
        }
        this.eventBuilder.addToDocumentPart(whitespace);
    }

    @Override
    public void handleScalar(Scalar scalar) {
        Key key = this.currentKey == null ? new Key() : this.currentKey;
        this.currentKey = null;
        if (!this.params.getExtractStandalone() && key == null) {
            this.eventBuilder.addDocumentPart(scalar.getOriginalString());
            return;
        }
        String resName = this.getKeyNames(key);
        boolean extract = this.params.getExtractAllPairs();
        if (this.exceptions != null && this.exceptions.matcher(resName).find()) {
            boolean bl = extract = !extract;
        }
        if (!extract) {
            this.eventBuilder.addToDocumentPart(scalar.getOriginalString());
            return;
        }
        this.eventBuilder.addDocumentPart(scalar.type.getQuoteChar());
        if (this.subFilter != null) {
            if (scalar.type == YamlScalarTypes.LITERAL && !this.params.isSubFilterProcessLiteralAsBlock()) {
                for (Line l : scalar.getTranslatableStrings()) {
                    if (l.isSkeleton) {
                        this.eventBuilder.addToDocumentPart(l.line);
                        continue;
                    }
                    if (l.line == null || l.line.isEmpty()) continue;
                    this.callSubfilter(l.line, scalar, key, resName);
                }
            } else if (scalar.type == YamlScalarTypes.LITERAL && this.params.isSubFilterProcessLiteralAsBlock()) {
                String normalize = StringUtil.removeAnyQualifiers(Line.decode(scalar.getOriginalString()));
                this.callSubfilter(normalize, scalar, key, resName);
            } else {
                String normalize = StringUtil.removeAnyQualifiers(Line.decode(scalar.getOriginalString()));
                normalize = this.collapseWhitespace(normalize);
                this.callSubfilter(normalize, scalar, key, resName);
            }
            this.eventBuilder.addDocumentPart(scalar.type.getQuoteChar());
            return;
        }
        int fullIndent = key.indent + this.extraIndent;
        if (scalar.indentedBlock != null && !scalar.indentedBlock.isEmpty()) {
            fullIndent = scalar.indentedBlock.firstIndent;
        }
        Property scalarType = new Property(YAML_SCALAR_TYPE_PROPERTY_NAME, scalar.type.name());
        Property flow = new Property(YAML_SCALAR_FLOW_PROPERTY_NAME, Boolean.toString(scalar.flow));
        Property indent = new Property(YAML_PARENT_INDENT_PROPERTY_NAME, Integer.toString(fullIndent));
        this.eventBuilder.startTextUnit();
        this.eventBuilder.setTextUnitName(resName);
        for (Line l : scalar.getTranslatableStrings()) {
            if (l.isSkeleton) {
                this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, "lb", l.line));
                continue;
            }
            if (l.line == null || l.line.isEmpty()) continue;
            this.eventBuilder.addToTextUnit(Util.normalizeNewlines(l.line));
        }
        ITextUnit tu = this.eventBuilder.peekMostRecentTextUnit();
        tu.setProperty(scalarType);
        tu.setProperty(flow);
        tu.setProperty(indent);
        this.eventBuilder.endTextUnit();
        this.eventBuilder.addDocumentPart(scalar.type.getQuoteChar());
        this.extraIndent = 0;
        this.logger.debug("KEYNAME: {}: {}", (Object)resName, (Object)scalar.getOriginalString());
    }

    private void callSubfilter(String subtext, Scalar scalar, Key key, String parentName) {
        String parentId = this.eventBuilder.findMostRecentParentId();
        if (parentId == null) {
            parentId = this.getDocumentId().getLastId();
        }
        YamlEncoder parentEncoder = new YamlEncoder();
        parentEncoder.setScalarType(scalar.type);
        try (SubFilter sf = new SubFilter(this.subFilter, parentEncoder, ++this.subfilterIndex, parentId, parentName);){
            int fullIndent = key.indent + this.extraIndent;
            if (scalar.indentedBlock != null && !scalar.indentedBlock.isEmpty()) {
                fullIndent = scalar.indentedBlock.firstIndent;
            }
            Property scalarType = new Property(YAML_SCALAR_TYPE_PROPERTY_NAME, scalar.type.name());
            Property flow = new Property(YAML_SCALAR_FLOW_PROPERTY_NAME, Boolean.toString(scalar.flow));
            Property indent = new Property(YAML_PARENT_INDENT_PROPERTY_NAME, Integer.toString(fullIndent));
            List<Event> subFilterEvents = sf.getEvents(new RawDocument(subtext, this.getSrcLoc()));
            for (Event event : subFilterEvents) {
                if (!event.isTextUnit()) continue;
                event.getTextUnit().setProperty(scalarType);
                event.getTextUnit().setProperty(flow);
                event.getTextUnit().setProperty(indent);
                event.getTextUnit().setPreserveWhitespaces(scalar.type == YamlScalarTypes.LITERAL);
            }
            this.eventBuilder.addFilterEvents(subFilterEvents);
            this.eventBuilder.addToDocumentPart(sf.createRefCode().toString());
        }
    }

    private String collapseWhitespace(String text) {
        return WHITESPACE_PATTERN.matcher(text).replaceAll(" ");
    }

    @Override
    public void handleMapStart(boolean flow) {
        this.eventBuilder.startGroup(new GenericSkeleton(flow ? "{" : ""), "Yaml Map Start");
        this.currentNodeType = flow ? YamlNodeTypes.FLOW_MAP : YamlNodeTypes.BLOCK_MAP;
        this.extraIndent = 0;
    }

    @Override
    public void handleMapEnd(boolean flow) {
        this.eventBuilder.endGroup(new GenericSkeleton(flow ? "}" : ""));
    }

    @Override
    public void handleSequenceStart(boolean flow) {
        this.eventBuilder.startGroup(new GenericSkeleton(flow ? "[" : ""), "Yaml List Start");
        this.currentNodeType = flow ? YamlNodeTypes.FLOW_SEQUENCE : YamlNodeTypes.BLOCK_SEQUENCE;
        this.extraIndent = 0;
    }

    @Override
    public void handleSequenceEnd(boolean flow) {
        this.eventBuilder.endGroup(new GenericSkeleton(flow ? "]" : ""));
    }

    @Override
    public void handleMarker(String marker) {
        if (marker == null) {
            return;
        }
        this.eventBuilder.addToDocumentPart(marker);
    }

    private String getKeyNames(Key key) {
        StringBuilder keyPath = new StringBuilder();
        if (!this.params.getUseKeyAsName()) {
            return null;
        }
        if (!this.params.getUseFullKeyPath()) {
            return key.getKeyName();
        }
        if (!this.keyStack.isEmpty()) {
            ListIterator it = this.keyStack.listIterator();
            while (it.hasNext()) {
                Key k = (Key)it.next();
                if (k == null || k.isEmpty()) continue;
                if (keyPath.length() > 0) {
                    keyPath.append("/");
                }
                keyPath.append(k.getKeyName());
            }
        }
        return keyPath.toString();
    }

    @Override
    public void handleOther(String other) {
        if (other == null) {
            return;
        }
        this.eventBuilder.addToDocumentPart(other);
    }

    @Override
    public void handleDocumentStart(String start) {
        this.keyStack.clear();
        this.currentNodeType = YamlNodeTypes.UNKNOWN;
        this.currentKey = null;
        this.eventBuilder.addToDocumentPart(start);
        this.extraIndent = 0;
    }

    @Override
    public void handleDocumentEnd(String end) {
        this.keyStack.clear();
        this.currentNodeType = YamlNodeTypes.UNKNOWN;
        this.currentKey = null;
        this.eventBuilder.addToDocumentPart(end);
        this.extraIndent = 0;
    }

    @Override
    public void handleMappingElementEnd() {
        this.keyStack.pop();
    }

    @Override
    public void handleBlockSequenceNodeStart(String dash, int indent) {
        this.eventBuilder.addToDocumentPart(dash);
        this.extraIndent = indent;
    }
}

