/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Cell;
import net.sf.okapi.filters.openxml.Cells;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.WorksheetFragments;
import net.sf.okapi.filters.openxml.XMLEventsReader;

interface Worksheet {
    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements Worksheet {
        private static final String SHEET_VIEW = "sheetView";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final boolean date1904;
        private final Cells cells;
        private final StyleDefinitions styleDefinitions;
        private final String name;
        private final WorksheetFragments fragments;
        private MarkupBuilder markupBuilder;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, boolean date1904, Cells cells, StyleDefinitions styleDefinitions, String name, WorksheetFragments fragments) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.date1904 = date1904;
            this.cells = cells;
            this.styleDefinitions = styleDefinitions;
            this.name = name;
            this.fragments = fragments;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.fragments.readWith(reader);
            HashSet<Integer> excludedRows = new HashSet<Integer>(this.conditionalParameters.worksheetConfigurations().excludedRowsFor(this.name));
            excludedRows.addAll(this.fragments.hiddenRows());
            Set<Integer> metadataRows = this.conditionalParameters.worksheetConfigurations().metadataRowsFor(this.name);
            excludedRows.addAll(metadataRows);
            HashSet<String> excludedColumns = new HashSet<String>(this.conditionalParameters.worksheetConfigurations().excludedColumnsFor(this.name));
            excludedColumns.addAll(this.fragments.hiddenColumns());
            Set<String> metadataColumns = this.conditionalParameters.worksheetConfigurations().metadataColumnsFor(this.name);
            excludedColumns.addAll(metadataColumns);
            this.markupBuilder = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            XMLEventsReader eventsReader = new XMLEventsReader(this.fragments.events());
            while (eventsReader.hasNext()) {
                EndElement ee;
                XMLEvent e = eventsReader.nextEvent();
                if (e.isStartElement()) {
                    StartElement se = e.asStartElement();
                    if (SHEET_VIEW.equals(se.getName().getLocalPart())) {
                        this.markupBuilder.add(new MarkupComponent.Start(this.eventFactory, se));
                        continue;
                    }
                    if ("c".equals(se.getName().getLocalPart())) {
                        Cell.Default cell = new Cell.Default(this.conditionalParameters, this.eventFactory, this.date1904, this.styleDefinitions, excludedRows, excludedColumns, metadataRows, metadataColumns, this.fragments.cellReferencesRanges(), this.name, se);
                        cell.readWith(eventsReader);
                        this.cells.add(cell);
                        this.markupBuilder.add(cell.asMarkup());
                        continue;
                    }
                } else if (e.isEndElement() && SHEET_VIEW.equals((ee = e.asEndElement()).getName().getLocalPart())) {
                    this.markupBuilder.add(new MarkupComponent.End(ee));
                    continue;
                }
                this.markupBuilder.add(e);
            }
        }

        @Override
        public Markup asMarkup() {
            return this.markupBuilder.build();
        }
    }
}

