/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;

final class ParametersStringWorksheetConfiguration
implements WorksheetConfiguration {
    static final String DELIMITER = ",";
    private static final String DELIMITING_EXPRESSION = "\\s*,\\s*";
    static final String NAME_PATTERN = "namePattern";
    static final String EXCLUDED_ROWS = "excludedRows";
    static final String EXCLUDED_COLUMNS = "excludedColumns";
    static final String METADATA_ROWS = "metadataRows";
    static final String METADATA_COLUMNS = "metadataColumns";
    private static final String EMPTY = "";
    private static final String DEFAULT_NAME_PATTERN = "";
    private static final String DEFAULT_EXCLUDED_ROWS = "";
    private static final String DEFAULT_EXCLUDED_COLUMNS = "";
    private static final String DEFAULT_METADATA_ROWS = "";
    private static final String DEFAULT_METADATA_COLUMNS = "";
    private final ParametersString parametersString;
    private WorksheetConfiguration worksheetConfiguration;
    private boolean read;

    ParametersStringWorksheetConfiguration(ParametersString parametersString) {
        this.parametersString = parametersString;
    }

    @Override
    public boolean matches(String worksheetName) {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.worksheetConfiguration.matches(worksheetName);
    }

    @Override
    public Set<Integer> excludedRows() {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.worksheetConfiguration.excludedRows();
    }

    @Override
    public Set<String> excludedColumns() {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.worksheetConfiguration.excludedColumns();
    }

    @Override
    public Set<Integer> metadataRows() {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.worksheetConfiguration.metadataRows();
    }

    @Override
    public Set<String> metadataColumns() {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.worksheetConfiguration.metadataColumns();
    }

    private void fromParametersString() {
        this.worksheetConfiguration = new WorksheetConfiguration.Default(this.parametersString.getString(NAME_PATTERN, ""), Arrays.stream(this.parametersString.getString(EXCLUDED_ROWS, "").split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).map(s -> Integer.parseUnsignedInt(s)).collect(Collectors.toList()), Arrays.stream(this.parametersString.getString(EXCLUDED_COLUMNS, "").split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).collect(Collectors.toList()), Arrays.stream(this.parametersString.getString(METADATA_ROWS, "").split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).map(s -> Integer.parseUnsignedInt(s)).collect(Collectors.toList()), Arrays.stream(this.parametersString.getString(METADATA_COLUMNS, "").split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
        this.read = true;
    }

    @Override
    public <T> T writtenTo(WorksheetConfiguration.Output<T> output) {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.worksheetConfiguration.writtenTo(output);
    }
}

