/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.openxml.AttributesClarification;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.CharactersClarification;
import net.sf.okapi.filters.openxml.ElementsClarification;
import net.sf.okapi.filters.openxml.Formula;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.RunProperties;

interface MarkupComponentClarification {
    public void performFor(MarkupComponent var1);

    public static final class Default
    implements MarkupComponentClarification {
        private final AttributesClarification attributesClarification;
        private final ElementsClarification elementsClarification;
        private final CharactersClarification charactersClarification;

        Default(AttributesClarification attributesClarification) {
            this(attributesClarification, new ElementsClarification.Bypass(), new CharactersClarification.Bypass());
        }

        Default(ElementsClarification elementsClarification) {
            this(new AttributesClarification.Bypass(), elementsClarification, new CharactersClarification.Bypass());
        }

        Default(CharactersClarification charactersClarification) {
            this(new AttributesClarification.Bypass(), new ElementsClarification.Bypass(), charactersClarification);
        }

        Default(AttributesClarification attributesClarification, ElementsClarification elementsClarification) {
            this(attributesClarification, elementsClarification, new CharactersClarification.Bypass());
        }

        Default(AttributesClarification attributesClarification, ElementsClarification elementsClarification, CharactersClarification charactersClarification) {
            this.attributesClarification = attributesClarification;
            this.elementsClarification = elementsClarification;
            this.charactersClarification = charactersClarification;
        }

        @Override
        public void performFor(MarkupComponent markupComponent) {
            List<Attribute> attributes;
            if (MarkupComponent.isStart(markupComponent)) {
                attributes = ((MarkupComponent.Start)markupComponent).getAttributes();
                this.attributesClarification.adjustClarificationContextWith(((MarkupComponent.Start)markupComponent).context());
            } else if (MarkupComponent.isBlockProperties(markupComponent)) {
                attributes = ((BlockProperties)markupComponent).attributes();
            } else if (MarkupComponent.isRunProperties(markupComponent) || MarkupComponent.isFormula(markupComponent)) {
                attributes = Collections.emptyList();
            } else {
                throw new IllegalArgumentException("Unsupported markup component: ".concat(markupComponent.getClass().getSimpleName()));
            }
            this.attributesClarification.performFor(attributes);
            if (MarkupComponent.isBlockProperties(markupComponent)) {
                this.elementsClarification.performFor(((BlockProperties)markupComponent).properties());
            }
            if (MarkupComponent.isRunProperties(markupComponent)) {
                this.elementsClarification.performFor(((RunProperties)markupComponent).properties());
            }
            if (MarkupComponent.isFormula(markupComponent)) {
                this.charactersClarification.adjustClarificationContextWith(((Formula)markupComponent).context());
                this.charactersClarification.performFor(((Formula)markupComponent).innerEvents());
            }
        }
    }
}

