/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ListIterator;
import net.sf.okapi.filters.openxml.BlockPropertiesClarification;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupClarificationConfiguration;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentClarification;
import net.sf.okapi.filters.openxml.StylesClarification;

class MarkupClarification {
    private final MarkupComponentClarification sheetViewClarification;
    private final MarkupComponentClarification alignmentClarification;
    private final MarkupComponentClarification nameTranslationClarification;
    private final MarkupComponentClarification sheetTranslationClarification;
    private final MarkupComponentClarification formulaTranslationClarification;
    private final MarkupComponentClarification presentationClarification;
    private final BlockPropertiesClarification tablePropertiesClarification;
    private final BlockPropertiesClarification textBodyPropertiesClarification;
    private final BlockPropertiesClarification paragraphPropertiesClarification;
    private final StylesClarification wordStylesClarification;

    MarkupClarification(MarkupClarificationConfiguration configuration) {
        this(configuration.sheetViewClarification(), configuration.alignmentClarification(), configuration.nameTranslationClarification(), configuration.sheetTranslationClarification(), configuration.formulaTranslationClarification(), configuration.presentationClarification(), configuration.tablePropertiesClarification(), configuration.textBodyPropertiesClarification(), configuration.paragraphPropertiesClarification(), configuration.wordStylesClarification());
    }

    MarkupClarification(MarkupComponentClarification sheetViewClarification, MarkupComponentClarification alignmentClarification, MarkupComponentClarification nameTranslationClarification, MarkupComponentClarification sheetTranslationClarification, MarkupComponentClarification formulaTranslationClarification, MarkupComponentClarification presentationClarification, BlockPropertiesClarification tablePropertiesClarification, BlockPropertiesClarification textBodyPropertiesClarification, BlockPropertiesClarification paragraphPropertiesClarification, StylesClarification wordStylesClarification) {
        this.sheetViewClarification = sheetViewClarification;
        this.alignmentClarification = alignmentClarification;
        this.nameTranslationClarification = nameTranslationClarification;
        this.sheetTranslationClarification = sheetTranslationClarification;
        this.formulaTranslationClarification = formulaTranslationClarification;
        this.presentationClarification = presentationClarification;
        this.tablePropertiesClarification = tablePropertiesClarification;
        this.textBodyPropertiesClarification = textBodyPropertiesClarification;
        this.paragraphPropertiesClarification = paragraphPropertiesClarification;
        this.wordStylesClarification = wordStylesClarification;
    }

    void performFor(Markup markup) {
        ListIterator<MarkupComponent> iterator = markup.components().listIterator();
        while (iterator.hasNext()) {
            MarkupComponent component = iterator.next();
            if (MarkupComponent.isSheetViewStart(component)) {
                this.sheetViewClarification.performFor(component);
                continue;
            }
            if (MarkupComponent.isAlignmentStart(component)) {
                this.alignmentClarification.performFor(component);
                continue;
            }
            if (MarkupComponent.isTableColumnStart(component) || MarkupComponent.isDataFieldStart(component) || MarkupComponent.isCacheFieldStart(component)) {
                this.nameTranslationClarification.performFor(component);
                continue;
            }
            if (MarkupComponent.isWorksheetSourceStart(component)) {
                this.sheetTranslationClarification.performFor(component);
                continue;
            }
            if (MarkupComponent.isFormula(component)) {
                this.formulaTranslationClarification.performFor(component);
                continue;
            }
            if (MarkupComponent.isPresentationStart(component)) {
                this.presentationClarification.performFor(component);
                continue;
            }
            if (MarkupComponent.isTableStart(component)) {
                this.tablePropertiesClarification.performWith(iterator);
                continue;
            }
            if (MarkupComponent.isTextBodyStart(component)) {
                this.textBodyPropertiesClarification.performWith(iterator);
                continue;
            }
            if (MarkupComponent.isParagraphStart(component)) {
                this.paragraphPropertiesClarification.performWith(iterator);
                continue;
            }
            if (!MarkupComponent.isWordStylesStart(component)) continue;
            this.wordStylesClarification.performWith(iterator);
        }
    }
}

