/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.PatternFill;

interface Fill {
    public static final String NAME = "fill";

    public PatternFill pattern();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements Fill {
        private static final String GRADIENT_FILL = "gradientFill";
        private final StartElement startElement;
        private List<XMLEvent> gradientFillEvents;
        private PatternFill patternFill;
        private EndElement endElement;

        Default(StartElement startElement) {
            this.startElement = startElement;
        }

        @Override
        public PatternFill pattern() {
            if (null == this.patternFill) {
                this.patternFill = new PatternFill.Empty();
            }
            return this.patternFill;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if (GRADIENT_FILL.equals(se.getName().getLocalPart())) {
                    this.gradientFillEvents = Default.eventsFor(se, reader);
                    continue;
                }
                if ("patternFill".equals(se.getName().getLocalPart())) {
                    this.patternFill = new PatternFill.Default(se);
                    this.patternFill.readWith(reader);
                    continue;
                }
                throw new IllegalStateException("Unsupported element found: ".concat(se.getName().getLocalPart()));
            }
        }

        private static List<XMLEvent> eventsFor(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                events.add(e);
                if (!e.isEndElement() || !e.asEndElement().getName().equals(startElement.getName())) continue;
                break;
            }
            return events;
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new LinkedList<MarkupComponent>()));
            mb.add(this.startElement);
            if (null != this.gradientFillEvents) {
                mb.addAll(this.gradientFillEvents);
            }
            mb.add(this.pattern().asMarkup());
            mb.add(this.endElement);
            return mb.build();
        }
    }

    public static final class Empty
    implements Fill {
        @Override
        public PatternFill pattern() {
            return new PatternFill.Empty();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

