/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellFormat;
import net.sf.okapi.filters.openxml.CellStyle;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DifferentialFormat;
import net.sf.okapi.filters.openxml.Fill;
import net.sf.okapi.filters.openxml.Font;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.NumberFormat;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinition;

interface ExcelStyleDefinition
extends StyleDefinition {

    public static final class Extensions
    implements ExcelStyleDefinition {
        static final String NAME = "extLst";
        private final Default defaultStyleDefinition;

        Extensions(Default defaultStyleDefinition) {
            this.defaultStyleDefinition = defaultStyleDefinition;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultStyleDefinition.readWith(reader);
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            return this.defaultStyleDefinition.paragraphProperties();
        }

        @Override
        public RunProperties runProperties() {
            return this.defaultStyleDefinition.runProperties();
        }

        @Override
        public Markup asMarkup() {
            return this.defaultStyleDefinition.asMarkup();
        }
    }

    public static final class Colors
    implements ExcelStyleDefinition {
        static final String NAME = "colors";
        private final Default defaultStyleDefinition;

        Colors(Default defaultStyleDefinition) {
            this.defaultStyleDefinition = defaultStyleDefinition;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultStyleDefinition.readWith(reader);
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            return this.defaultStyleDefinition.paragraphProperties();
        }

        @Override
        public RunProperties runProperties() {
            return this.defaultStyleDefinition.runProperties();
        }

        @Override
        public Markup asMarkup() {
            return this.defaultStyleDefinition.asMarkup();
        }
    }

    public static final class TableStyles
    implements ExcelStyleDefinition {
        static final String NAME = "tableStyles";
        private final Default defaultStyleDefinition;

        TableStyles(Default defaultStyleDefinition) {
            this.defaultStyleDefinition = defaultStyleDefinition;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultStyleDefinition.readWith(reader);
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            return this.defaultStyleDefinition.paragraphProperties();
        }

        @Override
        public RunProperties runProperties() {
            return this.defaultStyleDefinition.runProperties();
        }

        @Override
        public Markup asMarkup() {
            return this.defaultStyleDefinition.asMarkup();
        }
    }

    public static final class DifferentialFormats
    implements ExcelStyleDefinition {
        static final String NAME = "dxfs";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<DifferentialFormat> formats;
        private EndElement endElement;

        DifferentialFormats(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement) {
            this(conditionalParameters, eventFactory, startElement, new ArrayList<DifferentialFormat>());
        }

        DifferentialFormats(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement, List<DifferentialFormat> formats) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.formats = formats;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement() || !"dxf".equals(e.asStartElement().getName().getLocalPart())) continue;
                DifferentialFormat.Default format = new DifferentialFormat.Default(this.conditionalParameters, this.eventFactory, e.asStartElement());
                format.readWith(reader);
                this.formats.add(format);
            }
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (this.formats.isEmpty() && !this.startElement.getAttributes().hasNext()) {
                return markup;
            }
            MarkupBuilder mb = new MarkupBuilder(markup);
            mb.add(this.startElement);
            this.formats.forEach(format -> mb.add(format.asMarkup()));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }

    public static final class CellStyles
    implements ExcelStyleDefinition {
        static final String NAME = "cellStyles";
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<CellStyle> styles;
        private EndElement endElement;

        CellStyles(XMLEventFactory eventFactory, StartElement startElement) {
            this(eventFactory, startElement, new ArrayList<CellStyle>());
        }

        CellStyles(XMLEventFactory eventFactory, StartElement startElement, List<CellStyle> styles) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.styles = styles;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement() || !"cellStyle".equals(e.asStartElement().getName().getLocalPart())) continue;
                CellStyle.Default style = new CellStyle.Default(e.asStartElement());
                style.readWith(reader);
                this.styles.add(style);
            }
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (this.styles.isEmpty()) {
                return markup;
            }
            MarkupBuilder mb = new MarkupBuilder(markup);
            mb.add(this.startElement);
            this.styles.forEach(style -> mb.add(style.asMarkup()));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }

    public static final class CellFormats
    implements ExcelStyleDefinition {
        static final String NAME = "cellXfs";
        static final int DEFAULT_INDEX = 0;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<CellFormat> formats;
        private EndElement endElement;

        CellFormats(XMLEventFactory eventFactory, StartElement startElement) {
            this(eventFactory, startElement, new ArrayList<CellFormat>());
        }

        CellFormats(XMLEventFactory eventFactory, StartElement startElement, List<CellFormat> formats) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.formats = formats;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement() || !"xf".equals(e.asStartElement().getName().getLocalPart())) continue;
                CellFormat.Default format = new CellFormat.Default(this.eventFactory, e.asStartElement());
                format.readWith(reader);
                this.formats.add(format);
            }
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        CellFormat referencedBy(int index) {
            if (0 > index || index >= this.formats.size()) {
                throw new IllegalStateException("The requested format is not available: ".concat(String.valueOf(index)));
            }
            return this.formats.get(index);
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (this.formats.isEmpty()) {
                return markup;
            }
            MarkupBuilder mb = new MarkupBuilder(markup);
            mb.add(this.startElement);
            this.formats.forEach(style -> mb.add(style.asMarkup()));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }

    public static final class CellStyleFormats
    implements ExcelStyleDefinition {
        static final String NAME = "cellStyleXfs";
        private final CellFormats cellFormats;

        CellStyleFormats(CellFormats cellFormats) {
            this.cellFormats = cellFormats;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.cellFormats.readWith(reader);
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            return this.cellFormats.paragraphProperties();
        }

        @Override
        public RunProperties runProperties() {
            return this.cellFormats.runProperties();
        }

        @Override
        public Markup asMarkup() {
            return this.cellFormats.asMarkup();
        }
    }

    public static final class Borders
    implements ExcelStyleDefinition {
        static final String NAME = "borders";
        private final Default defaultStyleDefinition;

        Borders(Default defaultStyleDefinition) {
            this.defaultStyleDefinition = defaultStyleDefinition;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.defaultStyleDefinition.readWith(reader);
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            return this.defaultStyleDefinition.paragraphProperties();
        }

        @Override
        public RunProperties runProperties() {
            return this.defaultStyleDefinition.runProperties();
        }

        @Override
        public Markup asMarkup() {
            return this.defaultStyleDefinition.asMarkup();
        }
    }

    public static final class Fills
    implements ExcelStyleDefinition {
        static final String NAME = "fills";
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<Fill> fills;
        private EndElement endElement;

        Fills(XMLEventFactory eventFactory, StartElement startElement) {
            this(eventFactory, startElement, new ArrayList<Fill>());
        }

        Fills(XMLEventFactory eventFactory, StartElement startElement, List<Fill> fills) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.fills = fills;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement() || !"fill".equals(e.asStartElement().getName().getLocalPart())) continue;
                Fill.Default fill = new Fill.Default(e.asStartElement());
                fill.readWith(reader);
                this.fills.add(fill);
            }
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        Fill referencedBy(int id) {
            if (0 > id || id >= this.fills.size()) {
                throw new IllegalStateException("The requested fill is not available: ".concat(String.valueOf(id)));
            }
            return this.fills.get(id);
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (this.fills.isEmpty()) {
                return markup;
            }
            MarkupBuilder mb = new MarkupBuilder(markup);
            mb.add(this.startElement);
            this.fills.forEach(fill -> mb.add(fill.asMarkup()));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }

    public static final class Fonts
    implements ExcelStyleDefinition {
        static final String NAME = "fonts";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<Font> fonts;
        private EndElement endElement;

        Fonts(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement) {
            this(conditionalParameters, eventFactory, startElement, new ArrayList<Font>());
        }

        Fonts(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement, List<Font> fonts) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.fonts = fonts;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement() || !"font".equals(e.asStartElement().getName().getLocalPart())) continue;
                Font.Default font = new Font.Default(this.conditionalParameters, this.eventFactory, e.asStartElement());
                font.readWith(reader);
                this.fonts.add(font);
            }
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        Font referencedBy(int id) {
            if (0 > id || id >= this.fonts.size()) {
                throw new IllegalStateException("The requested font is not available: ".concat(String.valueOf(id)));
            }
            return this.fonts.get(id);
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (this.fonts.isEmpty()) {
                return markup;
            }
            MarkupBuilder mb = new MarkupBuilder(markup);
            mb.add(this.startElement);
            this.fonts.forEach(font -> mb.add(font.asMarkup()));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }

    public static final class NumberFormats
    implements ExcelStyleDefinition {
        static final String NAME = "numFmts";
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final Map<Integer, NumberFormat> formats;
        private EndElement endElement;

        NumberFormats(XMLEventFactory eventFactory, StartElement startElement) {
            this(eventFactory, startElement, new HashMap<Integer, NumberFormat>());
        }

        NumberFormats(XMLEventFactory eventFactory, StartElement startElement, Map<Integer, NumberFormat> formats) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.formats = formats;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement() || !"numFmt".equals(e.asStartElement().getName().getLocalPart())) continue;
                NumberFormat.Explicit format = new NumberFormat.Explicit(e.asStartElement());
                format.readWith(reader);
                this.formats.put(format.id(), format);
            }
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        NumberFormat referencedBy(int id) {
            if (this.formats.containsKey(id)) {
                return this.formats.get(id);
            }
            if (NumberFormat.BuiltIn.ids.contains(id)) {
                return new NumberFormat.BuiltIn(id);
            }
            throw new IllegalStateException("The requested number format is not available: ".concat(String.valueOf(id)));
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (this.formats.isEmpty() || this.formats.entrySet().stream().anyMatch(e -> NumberFormat.BuiltIn.ids.contains(e.getKey()))) {
                return markup;
            }
            MarkupBuilder mb = new MarkupBuilder(markup);
            mb.add(this.startElement);
            this.formats.entrySet().stream().filter(e -> !NumberFormat.BuiltIn.ids.contains(e.getKey())).forEach(fe -> mb.add(((NumberFormat)fe.getValue()).asMarkup()));
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }

    public static final class Default
    implements ExcelStyleDefinition {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final List<XMLEvent> events;
        private EndElement endElement;

        Default(XMLEventFactory eventFactory, StartElement startElement) {
            this(eventFactory, startElement, new LinkedList<XMLEvent>());
        }

        Default(XMLEventFactory eventFactory, StartElement startElement, List<XMLEvent> events) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.events = events;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                this.events.add(e);
            }
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunProperties runProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Markup asMarkup() {
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            if (this.events.isEmpty() && !this.startElement.getAttributes().hasNext()) {
                return markup;
            }
            MarkupBuilder mb = new MarkupBuilder(markup);
            mb.add(this.startElement);
            mb.addAll(this.events);
            mb.add(this.endElement());
            return mb.build();
        }

        private EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(this.startElement.getName(), this.startElement.getNamespaces());
            }
            return this.endElement;
        }
    }
}

