/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Objects;

final class CellReference {
    private final String string;
    private int row;
    private String column;
    private boolean split;

    CellReference(String string) {
        this.string = string;
    }

    int row() {
        if (!this.split) {
            this.split();
        }
        return this.row;
    }

    String column() {
        if (!this.split) {
            this.split();
        }
        return this.column;
    }

    private void split() {
        char[] chars;
        StringBuilder rowNumber = new StringBuilder();
        StringBuilder columnName = new StringBuilder();
        for (char ch : chars = this.string.toCharArray()) {
            if (Character.isDigit(ch)) {
                rowNumber.append(ch);
                continue;
            }
            columnName.append(ch);
        }
        this.row = Integer.parseUnsignedInt(rowNumber.toString());
        this.column = columnName.toString();
        this.split = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellReference that = (CellReference)o;
        return this.string.equals(that.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }

    public String toString() {
        return this.string;
    }
}

