/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedList;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface CellAlignment {
    public static final String NAME = "alignment";

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements CellAlignment {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private EndElement endElement;

        Default(XMLEventFactory eventFactory, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (!e.isEndElement() || !e.asEndElement().getName().equals(this.startElement.getName())) continue;
                this.endElement = e.asEndElement();
                break;
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            markup.addComponent(new MarkupComponent.Start(this.eventFactory, this.startElement));
            markup.addComponent(new MarkupComponent.End(this.endElement));
            return markup;
        }
    }

    public static final class Empty
    implements CellAlignment {
        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

