/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellReference;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.CellType;
import net.sf.okapi.filters.openxml.CellValue;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DifferentialFormat;
import net.sf.okapi.filters.openxml.Formula;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MetadataContext;
import net.sf.okapi.filters.openxml.StyleDefinitions;

interface Cell {
    public static final String NAME = "c";

    public CellType type();

    public String worksheetName();

    public CellReferencesRange cellReferencesRange();

    public boolean valuePresent();

    public CellValue value();

    public List<XMLEvent> inlineStringEvents();

    public boolean excluded();

    public MetadataContext metadataContext();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static class Default
    implements Cell {
        private static final String INLINE_STRING = "is";
        private static final QName CELL_LOCATION_REFERENCE = new QName("r");
        private static final QName CELL_TYPE = new QName("t");
        private static final QName CELL_STYLE = new QName("s");
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final boolean date1904;
        private final StyleDefinitions styleDefinitions;
        private final Set<Integer> excludedRows;
        private final Set<String> excludedColumns;
        private final Set<Integer> metadataRows;
        private final Set<String> metadataColumns;
        private final List<CellReferencesRange> cellReferencesRanges;
        private final String worksheetName;
        private final StartElement origStartElement;
        private StartElement startElement;
        private CellType type;
        private CellReferencesRange cellReferencesRange;
        private Formula formula;
        private CellValue value;
        private List<XMLEvent> inlineStringEvents;
        private boolean excluded;
        private MetadataContext metadataContext;
        private EndElement endElement;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, boolean date1904, StyleDefinitions styleDefinitions, Set<Integer> excludedRows, Set<String> excludedColumns, Set<Integer> metadataRows, Set<String> metadataColumns, List<CellReferencesRange> cellReferencesRanges, String worksheetName, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.date1904 = date1904;
            this.styleDefinitions = styleDefinitions;
            this.excludedRows = excludedRows;
            this.excludedColumns = excludedColumns;
            this.metadataRows = metadataRows;
            this.metadataColumns = metadataColumns;
            this.cellReferencesRanges = cellReferencesRanges;
            this.worksheetName = worksheetName;
            this.origStartElement = startElement;
        }

        @Override
        public CellType type() {
            return this.type;
        }

        @Override
        public String worksheetName() {
            return this.worksheetName;
        }

        @Override
        public CellReferencesRange cellReferencesRange() {
            return this.cellReferencesRange;
        }

        @Override
        public boolean valuePresent() {
            return null != this.value;
        }

        @Override
        public CellValue value() {
            return this.value;
        }

        @Override
        public List<XMLEvent> inlineStringEvents() {
            return this.inlineStringEvents;
        }

        @Override
        public boolean excluded() {
            return this.excluded;
        }

        @Override
        public MetadataContext metadataContext() {
            if (null == this.metadataContext) {
                boolean metadataRow = this.cellReferencesRange.rows().stream().anyMatch(r -> this.metadataRows.contains(r));
                boolean metadataColumn = this.cellReferencesRange.columns().stream().anyMatch(c -> this.metadataColumns.contains(c));
                this.metadataContext = metadataRow && metadataColumn ? MetadataContext.ROW_AND_COLUMN : (metadataRow ? MetadataContext.ROW : (metadataColumn ? MetadataContext.COLUMN : MetadataContext.NONE));
            }
            return this.metadataContext;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            Attribute typeAttr = this.origStartElement.getAttributeByName(CELL_TYPE);
            this.type = CellType.from(typeAttr);
            this.startElement = CellType.INLINE_STRING == this.type ? this.newStartElement(this.origStartElement, typeAttr) : this.origStartElement;
            this.cellReferencesRange = this.cellReferencesRange(new CellReference(this.startElement.getAttributeByName(CELL_LOCATION_REFERENCE).getValue()));
            DifferentialFormat.Combined format = this.combinedDifferentialFormatFor(this.startElement);
            boolean bl = this.excluded = !this.cellReferencesRange.partialMatch(this.excludedRows, this.excludedColumns) || this.excludedFor(format);
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("f".equals(se.getName().getLocalPart())) {
                    this.formula = new Formula.Default(se, new MarkupComponent.Context.Default(this.worksheetName));
                    this.formula.readWith(reader);
                    continue;
                }
                if ("v".equals(se.getName().getLocalPart())) {
                    this.value = new CellValue.Default(this.eventFactory, this.date1904, this.type, format, se);
                    this.value.readWith(reader);
                    continue;
                }
                if (!INLINE_STRING.equals(se.getName().getLocalPart())) continue;
                this.inlineStringEvents = Default.inlineStringEvents(se, reader);
                this.value = new CellValue.Default(this.eventFactory, this.date1904, CellType.SHARED_STRING, format, this.eventFactory.createStartElement(se.getName().getPrefix(), se.getName().getNamespaceURI(), "v"));
            }
        }

        private StartElement newStartElement(StartElement startElement, Attribute attribute) {
            ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute a = iterator.next();
                if (CELL_TYPE.equals(a.getName())) {
                    newAttributes.add(this.eventFactory.createAttribute(attribute.getName(), CellType.SHARED_STRING.toString()));
                    continue;
                }
                newAttributes.add(a);
            }
            return this.eventFactory.createStartElement(startElement.getName(), newAttributes.iterator(), startElement.getNamespaces());
        }

        private CellReferencesRange cellReferencesRange(CellReference cellReference) {
            return this.cellReferencesRanges.stream().filter(r -> r.first().equals(cellReference)).findFirst().orElse(new CellReferencesRange(cellReference));
        }

        private DifferentialFormat.Combined combinedDifferentialFormatFor(StartElement startElement) {
            Attribute styleAttr = startElement.getAttributeByName(CELL_STYLE);
            if (styleAttr == null) {
                return this.styleDefinitions.combinedDifferentialFormatFor(0);
            }
            int styleIndex = Integer.parseUnsignedInt(styleAttr.getValue());
            return this.styleDefinitions.combinedDifferentialFormatFor(styleIndex);
        }

        private boolean excludedFor(DifferentialFormat format) {
            return this.conditionalParameters.tsExcelExcludedColors.stream().anyMatch(c -> format.fill().pattern().foregroundColor().argb().equals(c));
        }

        private static List<XMLEvent> inlineStringEvents(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            XMLEvent e;
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            while (!(!reader.hasNext() || (e = reader.nextEvent()).isEndElement() && e.asEndElement().getName().equals(startElement.getName()))) {
                events.add(e);
            }
            return events;
        }

        @Override
        public Markup asMarkup() {
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            mb.add(this.startElement);
            if (null != this.formula) {
                mb.add(this.formula);
            }
            if (this.valuePresent()) {
                mb.add(this.value.asMarkup());
            }
            mb.add(this.endElement);
            return mb.build();
        }
    }
}

