/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.filters.json.parser.IJsonHandler;
import net.sf.okapi.filters.json.parser.JavaCharStream;
import net.sf.okapi.filters.json.parser.JsonKeyTypes;
import net.sf.okapi.filters.json.parser.JsonParserConstants;
import net.sf.okapi.filters.json.parser.JsonParserTokenManager;
import net.sf.okapi.filters.json.parser.JsonValueTypes;
import net.sf.okapi.filters.json.parser.ParseException;
import net.sf.okapi.filters.json.parser.Provider;
import net.sf.okapi.filters.json.parser.StringProvider;
import net.sf.okapi.filters.json.parser.Token;
import net.sf.okapi.filters.json.parser.TokenMgrException;

public class JsonParser
implements JsonParserConstants {
    private IJsonHandler handler = null;
    private JsonValueTypes valueType = JsonValueTypes.DEFAULT;
    public JsonParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int trace_indent = 0;
    private boolean trace_enabled;

    public void setHandler(IJsonHandler handler) {
        this.handler = handler;
    }

    public void parse() throws ParseException {
        this.handler.handleStart();
        this.json();
        if (!this.ensureEOF()) {
            throw new ParseException("Expected EOF, but still had content to parse");
        }
        this.handler.handleEnd();
    }

    public int getLine() {
        return this.jj_input_stream.getLine();
    }

    public int getColumn() {
        return this.jj_input_stream.getColumn();
    }

    public void handleIgnorable(Token t) {
        List<Token> specialTokenList = this.getSpecialTokensBefore(t);
        if (specialTokenList != null) {
            for (Token st : specialTokenList) {
                switch (st.kind) {
                    case 1: 
                    case 2: {
                        this.handler.handleComment(st.image);
                        break;
                    }
                    case 6: {
                        this.handler.handleComment(this.token_source.multiLineComment.toString());
                        this.token_source.multiLineComment.setLength(0);
                        break;
                    }
                    case 7: {
                        this.handler.handleComment("<!--" + st.image);
                        break;
                    }
                    case 11: {
                        this.handler.handleWhitespace(st.image);
                    }
                }
            }
        }
    }

    private List<Token> getSpecialTokensBefore(Token t) {
        if (t.specialToken == null) {
            return null;
        }
        ArrayList<Token> specialTokensList = new ArrayList<Token>();
        Token tmp_t = t.specialToken;
        while (tmp_t.specialToken != null) {
            tmp_t = tmp_t.specialToken;
        }
        while (tmp_t != null) {
            specialTokensList.add(tmp_t);
            tmp_t = tmp_t.next;
        }
        return specialTokensList;
    }

    private JsonKeyTypes getKeyType(Token nextToken) {
        switch (nextToken.kind) {
            case 13: {
                return JsonKeyTypes.OBJECT;
            }
            case 16: {
                return JsonKeyTypes.LIST;
            }
        }
        return JsonKeyTypes.VALUE;
    }

    private static String substringBefore(String str, char delim) {
        int pos = str.indexOf(delim);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public final boolean ensureEOF() throws ParseException {
        this.jj_consume_token(0);
        return true;
    }

    public final void json() throws ParseException {
        this.handleIgnorable(this.getToken(1));
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: {
                this.object();
                break;
            }
            case 16: {
                this.list();
                break;
            }
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                this.value();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.handleIgnorable(this.getToken(1));
    }

    public final void object() throws ParseException {
        this.jj_consume_token(13);
        this.handler.handleObjectStart();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                String key = this.objectKey();
                this.handleIgnorable(this.token);
                this.handler.handleKey(key, this.valueType, this.getKeyType(this.getToken(2)));
                this.valueType = JsonValueTypes.DEFAULT;
                this.handleIgnorable(this.getToken(1));
                this.jj_consume_token(15);
                this.handler.handleSeparator(this.token.image);
                this.json();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(12);
                    this.handleIgnorable(this.token);
                    this.handler.handleSeparator(this.token.image);
                    this.handleIgnorable(this.getToken(1));
                    key = this.objectKey();
                    this.handler.handleKey(key, this.valueType, this.getKeyType(this.getToken(2)));
                    this.valueType = JsonValueTypes.DEFAULT;
                    this.jj_consume_token(15);
                    this.handler.handleSeparator(this.token.image);
                    this.json();
                }
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(14);
        this.handler.handleObjectEnd();
    }

    public final void list() throws ParseException {
        this.jj_consume_token(16);
        this.handler.handleListStart();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 16: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                this.json();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(12);
                    this.handler.handleSeparator(this.token.image);
                    this.json();
                }
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(17);
        this.handler.handleListEnd();
    }

    public final String objectKey() throws ParseException {
        String key;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                key = this.string();
                break;
            }
            case 31: {
                key = this.symbol();
                break;
            }
            case 30: {
                key = this.nullValue();
                break;
            }
            case 23: 
            case 28: 
            case 29: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: 
                    case 29: {
                        key = this.booleanValue();
                        break block0;
                    }
                    case 23: {
                        key = this.number();
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return key;
    }

    public final void value() throws ParseException {
        String s;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                s = this.number();
                break;
            }
            case 28: 
            case 29: {
                s = this.booleanValue();
                break;
            }
            case 30: {
                s = this.nullValue();
                break;
            }
            case 31: {
                s = this.symbol();
                break;
            }
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                s = this.string();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.handler.handleValue(s, this.valueType);
        this.valueType = JsonValueTypes.DEFAULT;
    }

    public final String nullValue() throws ParseException {
        this.jj_consume_token(30);
        this.valueType = JsonValueTypes.NULL;
        return this.token.image;
    }

    public final String booleanValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.valueType = JsonValueTypes.BOOLEAN;
        return this.token.image;
    }

    public final String number() throws ParseException {
        this.jj_consume_token(23);
        this.valueType = JsonValueTypes.NUMBER;
        return this.token.image;
    }

    public final String string() throws ParseException {
        String s;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 36: 
            case 40: {
                s = this.doubleQuoteString();
                break;
            }
            case 35: 
            case 39: {
                s = this.singleQuoteString();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return s;
    }

    public final String doubleQuoteString() throws ParseException {
        String value = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                this.valueType = JsonValueTypes.DOUBLE_QUOTED_STRING;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                this.valueType = JsonValueTypes.DOUBLE_QUOTED_STRING;
                String image = this.token.image;
                value = image.substring(1, image.length() - 1);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final String singleQuoteString() throws ParseException {
        String value = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                this.valueType = JsonValueTypes.SINGLE_QUOTED_STRING;
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                this.valueType = JsonValueTypes.SINGLE_QUOTED_STRING;
                String image = this.token.image;
                value = image.substring(1, image.length() - 1);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final String symbol() throws ParseException {
        this.jj_consume_token(31);
        this.valueType = JsonValueTypes.SYMBOL;
        return this.token.image;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-259973120, 4096, -260046848, 4096, -259973120, 0x30800000, -260046848, -260046848, 0x30000000, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{408, 0, 408, 0, 408, 0, 408, 408, 0, 408, 272, 136};
    }

    public JsonParser(Provider stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JsonParser(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JsonParser(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[41];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 41; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : JsonParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        JsonParser.jj_la1_init_0();
        JsonParser.jj_la1_init_1();
    }
}

