/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupZipSkeleton;
import net.sf.okapi.filters.idml.SubDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MarkupModifiableSubDocument
implements SubDocument {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final ZipFile zipFile;
    private final ZipEntry entry;
    private final XMLOutputFactory outputFactory;
    private final String encoding;
    private final Markup markup;

    MarkupModifiableSubDocument(ZipFile zipFile, ZipEntry entry, XMLOutputFactory outputFactory, String encoding, Markup markup) {
        this.zipFile = zipFile;
        this.entry = entry;
        this.outputFactory = outputFactory;
        this.encoding = encoding;
        this.markup = markup;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        DocumentPart dp = new DocumentPart(this.entry.getName(), false);
        MarkupZipSkeleton skel = new MarkupZipSkeleton(this.zipFile, this.entry, this.outputFactory, this.encoding, this.markup);
        return new Event(EventType.DOCUMENT_PART, dp, skel);
    }

    @Override
    public boolean hasNextEvent() {
        return false;
    }

    @Override
    public Event nextEvent() {
        throw new IllegalStateException();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
        this.LOGGER.trace("[[ {}: {} ]]", (Object)this.getClass().getSimpleName(), (Object)this.entry.getName());
    }
}

