/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.doxygen.DelimiterTokenizer;
import net.sf.okapi.filters.doxygen.DoxygenCommand;
import net.sf.okapi.filters.doxygen.DoxygenParameter;
import net.sf.okapi.filters.doxygen.DoxygenPatterns;
import net.sf.okapi.filters.doxygen.DoxygenWriter;
import net.sf.okapi.filters.doxygen.ParameterExtractor;
import net.sf.okapi.filters.doxygen.Parameters;
import net.sf.okapi.filters.doxygen.PrefixSuffixTokenizer;
import net.sf.okapi.filters.doxygen.RegexTokenizer;
import net.sf.okapi.filters.doxygen.WhitespaceAdjustingEventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class DoxygenFilter
extends AbstractFilter {
    public static final String DOXYGEN_MIME_TYPE = "text/x-doxygen-txt";
    public static final String NUMLINES_PROPERTY = "numLines";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String linebreak = "\n";
    private WhitespaceAdjustingEventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private RawDocument currentRawDocument;
    private BOMNewlineEncodingDetector detector;
    private Parameters params;
    private StringBuilder commentBuffer;
    private PrefixSuffixTokenizer commentTokenizer;
    private IdentityHashMap<Pattern, Object> commandPatterns;

    public DoxygenFilter() {
        this.setMimeType(DOXYGEN_MIME_TYPE);
        this.setMultilingual(false);
        this.setFilterWriter(new DoxygenWriter());
        this.setName("okf_doxygen");
        this.setDisplayName("Doxygen Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), DOXYGEN_MIME_TYPE, this.getClass().getName(), "Doxygen-commented Text", "Doxygen-commented Text Documents", "doxygenConfiguration.yml", ".h;.c;.cpp;.java;.py;.m;"));
        this.setParameters(new Parameters());
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return super.createFilterWriter();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.currentRawDocument = input;
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setEncoding(input.getEncoding());
        this.hasUtf8Bom = this.detector.hasUtf8Bom();
        this.hasUtf8Encoding = this.detector.hasUtf8Encoding();
        this.linebreak = this.detector.getNewlineType().toString();
        this.setNewlineType(this.linebreak);
        this.commentBuffer = new StringBuilder();
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Overridding user set encoding (if any). Setting auto-detected encoding ({}).", (Object)detectedEncoding);
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Default encoding and detected encoding not found. Using best guess encoding ({})", (Object)detectedEncoding);
        }
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        BufferedReader reader = new BufferedReader(input.getReader());
        StringBuilder builder = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                builder.append(line + this.linebreak);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error reading Doxygen-commented file", e);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            this.LOGGER.warn("Error closing the Doxygen-commented text buffered reader.", (Throwable)e);
        }
        this.commentTokenizer = new PrefixSuffixTokenizer(DoxygenPatterns.tokenizerDelimiters, builder.toString());
        if (this.eventBuilder == null) {
            this.eventBuilder = new WhitespaceAdjustingEventBuilder();
        } else {
            this.eventBuilder.reset(null, this);
        }
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        this.eventBuilder.setPreserveWhitespace(this.params.isPreserveWhitespace());
        this.commandPatterns = new IdentityHashMap();
        for (Map.Entry<Pattern, Object> e : this.params.getCustomCommandPatterns().entrySet()) {
            this.commandPatterns.put(e.getKey(), null);
        }
        this.commandPatterns.put(DoxygenPatterns.DOXYGEN_COMMAND_PATTERN, null);
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(DOXYGEN_MIME_TYPE, "net.sf.okapi.common.encoder.DefaultEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        this.parse();
        return this.eventBuilder.next();
    }

    private void parse() {
        for (RegexTokenizer.Token t : this.commentTokenizer) {
            if (this.isCanceled()) {
                return;
            }
            if (t.prefixPattern() == null) {
                this.parseNonCommentString(t.toString());
            } else if (t.prefixPattern() == DoxygenPatterns.CPP_COMMENT_PREFIX_PATTERN) {
                this.parseSingleCommentLine(t);
            } else if (t.prefixPattern() == DoxygenPatterns.CPP_COMMENT_SUFFIX_PATTERN) {
                if (t.suffixPattern() == DoxygenPatterns.CPP_COMMENT_PREFIX_PATTERN && !t.toString().contains("\n")) {
                    GenericSkeleton skel = (GenericSkeleton)this.eventBuilder.peekMostRecentGroup().getSkeleton();
                    skel.append(t.toString());
                } else {
                    this.parseNonCommentString(t.toString());
                }
            } else if (t.prefixPattern() == DoxygenPatterns.JAVADOC_COMMENT_PREFIX_PATTERN || t.prefixPattern() == DoxygenPatterns.PYTHON_SINGLE_COMMENT_PREFIX_PATTERN || t.prefixPattern() == DoxygenPatterns.PYTHON_DOUBLE_COMMENT_PREFIX_PATTERN) {
                this.parseMultiLineComment(t);
            } else {
                this.parseNonCommentString(t.prefix() + t.toString());
            }
            if (!this.eventBuilder.hasQueuedEvents()) continue;
            return;
        }
        if (this.commentBuffer.length() != 0) {
            this.parseComment();
        }
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit();
        }
        if (this.eventBuilder.isCurrentGroup()) {
            this.eventBuilder.endGroup(null);
        }
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    private void parseNonCommentString(String line) {
        if (this.commentBuffer.length() != 0) {
            this.parseComment();
        }
        this.eventBuilder.addDocumentPart(line);
    }

    private void parseSingleCommentLine(RegexTokenizer.Token t) {
        if (!this.eventBuilder.isCurrentGroup()) {
            this.eventBuilder.startGroup(new GenericSkeleton(), null);
        }
        GenericSkeleton skel = (GenericSkeleton)this.eventBuilder.peekMostRecentGroup().getSkeleton();
        skel.append(t.prefix());
        skel.flushPart();
        this.commentBuffer.append(t.toString() + t.suffix());
    }

    private void parseMultiLineComment(RegexTokenizer.Token t) {
        if (this.commentBuffer.length() != 0) {
            this.parseComment();
        }
        if (!this.eventBuilder.isCurrentGroup()) {
            this.eventBuilder.startGroup(new GenericSkeleton(), null);
        }
        GenericSkeleton skel = (GenericSkeleton)this.eventBuilder.peekMostRecentGroup().getSkeleton();
        skel.append(t.prefix());
        DelimiterTokenizer tokenizer = new DelimiterTokenizer(DoxygenPatterns.MULTILINE_DECORATION_PATTERN, t.toString());
        String firstDelimiter = null;
        int numLines = 0;
        for (DelimiterTokenizer.Token u : tokenizer) {
            String body = u.toString();
            if (u.delimiter() != null) {
                String delimiter = u.delimiter();
                if (firstDelimiter == null && delimiter.length() > 0) {
                    firstDelimiter = delimiter;
                } else if (firstDelimiter != null && delimiter.length() > firstDelimiter.length()) {
                    body = delimiter.substring(firstDelimiter.length()) + body;
                    delimiter = delimiter.substring(0, firstDelimiter.length());
                }
                skel.append(delimiter);
                skel.flushPart();
                ++numLines;
            }
            this.commentBuffer.append(body);
        }
        this.eventBuilder.peekMostRecentGroup().setProperty(new Property(NUMLINES_PROPERTY, Integer.toString(numLines)));
        this.parseComment();
    }

    private void parseComment() {
        String text = this.commentBuffer.toString();
        this.commentBuffer.setLength(0);
        PrefixSuffixTokenizer tokenizer = new PrefixSuffixTokenizer(DoxygenPatterns.chunkDelimiters, text);
        for (RegexTokenizer.Token t : tokenizer) {
            GenericSkeleton skel = null;
            if (t.prefix() != null) {
                skel = new GenericSkeleton(t.prefix());
            }
            String chunk = t.toString();
            if (skel == null && chunk.length() == 0) continue;
            this.eventBuilder.startTextUnit(skel);
            this.parseCommentChunk(t.toString());
            this.eventBuilder.endTextUnit();
        }
        if (this.eventBuilder.isCurrentGroup()) {
            this.eventBuilder.endGroup(null);
        }
    }

    private void parseCommentChunk(String chunk) {
        Stack<DoxygenCommand> commandStack = new Stack<DoxygenCommand>();
        DelimiterTokenizer tokenizer = new DelimiterTokenizer(this.commandPatterns, chunk);
        for (DelimiterTokenizer.Token t : tokenizer) {
            DoxygenCommand prevCmd;
            if (t.delimiter() == null) {
                this.parsePlainText(t.toString());
                continue;
            }
            String cmd = WhitespaceAdjustingEventBuilder.collapseWhitespace(t.delimiter());
            if (t.delimiterPattern() == DoxygenPatterns.DOXYGEN_COMMAND_PATTERN && !this.isDoxygenCommand(cmd)) {
                this.LOGGER.warn("Invalid Doxygen command: {}", (Object)cmd);
                this.eventBuilder.addToTextUnit(cmd);
                this.parsePlainText(t.toString());
                continue;
            }
            DoxygenCommand cmdInfo = this.commandInfo(cmd, t.delimiterPattern());
            if (!this.eventBuilder.peekMostRecentTextUnit().isTranslatable() && !commandStack.isEmpty() && (prevCmd = (DoxygenCommand)commandStack.peek()).hasPair() && !prevCmd.getPair().equals(cmdInfo.getName())) {
                this.eventBuilder.addToTextUnit(cmd);
                this.eventBuilder.addToTextUnit(t.toString());
                continue;
            }
            Code code = new Code(cmdInfo.getTagType(), cmdInfo.getCanonicalName(), cmd);
            if (cmdInfo.getTagType() == TextFragment.TagType.CLOSING && !cmdInfo.isInline()) {
                DoxygenCommand prevCmd2;
                this.eventBuilder.addToTextUnit(code);
                this.eventBuilder.endTextUnit();
                this.eventBuilder.startTextUnit();
                if (commandStack.empty()) {
                    this.LOGGER.warn("Orphaned end command: {}", (Object)cmd);
                }
                while (!(commandStack.empty() || (prevCmd2 = (DoxygenCommand)commandStack.pop()).hasPair() && prevCmd2.getPair().equals(cmdInfo.getName()))) {
                    this.LOGGER.warn("Command not closed: {}", (Object)prevCmd2.getName());
                }
            } else if (cmdInfo.isInline()) {
                this.eventBuilder.addToTextUnit(code);
            } else {
                if (this.eventBuilder.canStartNewTextUnit()) {
                    this.eventBuilder.startTextUnit();
                } else if (this.eventBuilder.peekMostRecentTextUnit().getSource().hasText(false)) {
                    this.eventBuilder.endTextUnit();
                    this.eventBuilder.startTextUnit();
                }
                this.eventBuilder.addToTextUnit(code);
                this.eventBuilder.peekMostRecentTextUnit().setIsTranslatable(cmdInfo.isTranslatable());
                this.eventBuilder.peekMostRecentTextUnit().setPreserveWhitespaces(cmdInfo.isPreserveWhitespace());
                if (cmdInfo.getTagType() == TextFragment.TagType.OPENING) {
                    commandStack.push(cmdInfo);
                }
            }
            String remainingText = this.parseParameters(cmdInfo, t.toString(), code);
            if (!cmdInfo.isTranslatable() || cmdInfo.isPreserveWhitespace()) {
                this.eventBuilder.addToTextUnit(remainingText);
                continue;
            }
            this.parsePlainText(remainingText);
        }
        while (!commandStack.isEmpty()) {
            this.LOGGER.warn("{} was not closed.", (Object)((DoxygenCommand)commandStack.pop()).getName());
        }
    }

    private String parseParameters(DoxygenCommand cmd, String text, Code code) {
        if (!cmd.hasParameters()) {
            return text;
        }
        boolean canAddToCode = true;
        for (DoxygenParameter p : cmd) {
            ParameterExtractor extractor = new ParameterExtractor(p, text);
            text = extractor.remainder();
            if (!extractor.hasParameter() && !cmd.isInline()) {
                code.append(extractor.frontWhitespace());
                break;
            }
            if (p.isTranslatable()) {
                this.eventBuilder.addToTextUnit(extractor.parameter());
                canAddToCode = false;
            } else if (canAddToCode) {
                code.append(extractor.parameter());
            } else {
                this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, cmd.getCanonicalName(), extractor.parameter()));
            }
            if (p.length() != DoxygenParameter.ParameterLength.PARAGRAPH && p.length() != DoxygenParameter.ParameterLength.LINE) continue;
            this.eventBuilder.endTextUnit();
            this.eventBuilder.startTextUnit();
            canAddToCode = false;
        }
        if (canAddToCode && !cmd.isInline()) {
            Matcher m = ParameterExtractor.FRONT_WHITESPACE_PATTERN.matcher(text);
            m.find();
            code.append(m.group());
            text = text.substring(m.end());
        }
        return text;
    }

    private void parsePlainText(String text) {
        if (text.length() == 0) {
            return;
        }
        DelimiterTokenizer tokenizer = new DelimiterTokenizer(DoxygenPatterns.BLANK_LINES_PATTERN, text);
        for (DelimiterTokenizer.Token t : tokenizer) {
            if (t.delimiter() != null) {
                this.eventBuilder.addToTextUnit(t.delimiter());
                if (this.eventBuilder.peekMostRecentTextUnit().getSource().hasText(false)) {
                    this.eventBuilder.endTextUnit();
                    this.eventBuilder.startTextUnit();
                }
            }
            this.eventBuilder.addToTextUnit(t.toString());
        }
    }

    private boolean isDoxygenCommand(String cmd) {
        return this.params.isDoxygenCommand(cmd);
    }

    private DoxygenCommand commandInfo(String cmd, Pattern p) {
        return this.params.commandInfo(cmd, p);
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }
}

