/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.connectors.microsoft.QueryResultBuilder;
import net.sf.okapi.connectors.microsoft.TranslationResponse;
import net.sf.okapi.lib.translation.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FragmentQueryResultBuilder
extends QueryResultBuilder<TextFragment> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private QueryUtil util = new QueryUtil();

    FragmentQueryResultBuilder(Parameters params, int weight) {
        super(params, weight);
    }

    @Override
    List<QueryResult> convertResponses(List<TranslationResponse> responses, TextFragment frag) {
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        for (TranslationResponse response : responses) {
            QueryResult qr = this.createQueryResult(response);
            try {
                qr.source = response.sourceText == null ? frag : this.makeFragment(response.sourceText, frag);
                qr.target = this.makeFragment(response.translatedText, frag);
            }
            catch (InvalidContentException e) {
                this.logger.error("This MT candidate will be ignored.\n{}\n{}", (Object)frag.toString(), (Object)e.getMessage());
                qr.setQuality(QueryResult.QUALITY_UNDEFINED);
                qr.setFuzzyScore(0);
                qr.setCombinedScore(0);
                qr.source = frag;
                qr.target = frag.clone();
            }
            results.add(qr);
        }
        return results;
    }

    private TextFragment makeFragment(String codedHtml, TextFragment sourceFragment) {
        return sourceFragment.hasCode() ? new TextFragment(this.util.fromCodedHTML(codedHtml, sourceFragment, false), sourceFragment.getClonedCodes()) : new TextFragment(this.util.fromCodedHTML(codedHtml, sourceFragment, false));
    }
}

