/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilters {
    private static final String BUNDLE_NAME = "net.sf.okapi.common.filters.DefaultFilters";

    public static void setMappings(IFilterConfigurationMapper fcMapper, boolean reset, boolean addConfigurations) {
        ResourceBundle res = ResourceBundle.getBundle(BUNDLE_NAME);
        Enumeration<String> keys = res.getKeys();
        ArrayList<String> list = Collections.list(keys);
        if (reset) {
            fcMapper.clearConfigurations(false);
            fcMapper.clearDescriptionProviders();
            fcMapper.clearEditors();
        }
        for (String key : list) {
            if (!key.startsWith("filterClass")) continue;
            try {
                String key2;
                int n = key.indexOf(95);
                String suffix = key.substring(n);
                String value = res.getString(key);
                if (addConfigurations) {
                    fcMapper.addConfigurations(value);
                }
                if (!list.contains(key2 = "parametersClass" + suffix)) continue;
                String paramsClass = res.getString(key2);
                String key3 = "parametersEditorClass" + suffix;
                if (list.contains(key3)) {
                    value = res.getString(key3);
                    fcMapper.addEditor(value, paramsClass);
                    continue;
                }
                key3 = "editorDescriptionProvider" + suffix;
                if (!list.contains(key3)) continue;
                value = res.getString(key3);
                fcMapper.addDescriptionProvider(value, paramsClass);
            }
            catch (Exception ex) {
                Logger logger = LoggerFactory.getLogger(DefaultFilters.class);
                logger.warn("Error while trying to build filter for property key {}. Details: {}", (Object)key, (Object)ex);
            }
        }
    }
}

