/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class UnicodeBOMWriter
extends Writer {
    private static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    private static final byte[] BOM_UTF16BE = new byte[]{-2, -1};
    private static final byte[] BOM_UTF16LE = new byte[]{-1, -2};
    private static final byte[] BOM_UTF32BE = new byte[]{0, 0, -2, -1};
    private static final byte[] BOM_UTF32LE = new byte[]{-1, -2, 0, 0};
    private final Writer wrappedWriter;

    public UnicodeBOMWriter(File file, String charsetName) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        Charset cs = Charset.forName(charsetName);
        this.wrappedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, cs));
        this.writeBomIfNeeded(fos, cs.name());
    }

    public UnicodeBOMWriter(String fileName, String charsetName) throws IOException {
        this(new File(fileName), charsetName);
    }

    private void writeBomIfNeeded(OutputStream out, String charsetName) throws IOException {
        switch (charsetName) {
            case "UTF-8": {
                out.write(BOM_UTF8);
                break;
            }
            case "UTF-16": {
                break;
            }
            case "UTF-16BE": {
                out.write(BOM_UTF16BE);
                break;
            }
            case "UTF-16LE": {
                out.write(BOM_UTF16LE);
                break;
            }
            case "UTF-32": 
            case "UTF-32BE": {
                out.write(BOM_UTF32BE);
                break;
            }
            case "UTF-32LE": {
                out.write(BOM_UTF32LE);
                break;
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.wrappedWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.wrappedWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrappedWriter.close();
    }
}

