/*===========================================================================
  Copyright (C) 2016-2017 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
===========================================================================*/

package net.sf.okapi.common;

/**
 * An extensive list of {@link LocaleId}s predefined for easy access.
 *
 * @author hargraveje
 *
 */
public interface IPredefinedLocales {
	static public final LocaleId Afrikaans = LocaleId.fromString("af_ZA");
	static public final LocaleId Albanian = LocaleId.fromString("sq_AL");
	static public final LocaleId Amharic = LocaleId.fromString("amh_ET");
	static public final LocaleId Armenian = LocaleId.fromString("hy_AM");
	static public final LocaleId Aymara = LocaleId.fromString("ayc_PE");

	static public final LocaleId Basque = LocaleId.fromString("eu_ES");
	static public final LocaleId Bikolano = LocaleId.fromString("bik_PH");
	static public final LocaleId Bislama = LocaleId.fromString("bis_VU");
	static public final LocaleId Bulgarian = LocaleId.fromString("bg_BG");
	static public final LocaleId Burmese = LocaleId.fromString("mya_MM");

	static public final LocaleId Cebuano = LocaleId.fromString("ceb_PH");
	static public final LocaleId Chuukese = LocaleId.fromString("chk_FM");
	static public final LocaleId Croatian = LocaleId.fromString("hr_HR");
	static public final LocaleId Czech = LocaleId.fromString("cs_CZ");

	static public final LocaleId Danish = LocaleId.fromString("da_DK");
	static public final LocaleId Dutch = LocaleId.fromString("nl_NL");

	static public final LocaleId Efik = LocaleId.fromString("efi_NG");
	static public final LocaleId Estonian = LocaleId.fromString("et_EE");

	static public final LocaleId Fante = LocaleId.fromString("fan_GH");
	static public final LocaleId Fijian = LocaleId.fromString("fij_FJ");
	static public final LocaleId Finnish = LocaleId.fromString("fi_FI");

	static public final LocaleId Georgian = LocaleId.fromString("ka_GE");
	static public final LocaleId Greek = LocaleId.fromString("el_GR");
	static public final LocaleId Guarani = LocaleId.fromString("gug_PY");

	static public final LocaleId Haitian = LocaleId.fromString("hat_HT");
	static public final LocaleId Hiligaynon = LocaleId.fromString("hil_PH");
	static public final LocaleId Hindi = LocaleId.fromString("hi_IN");
	static public final LocaleId Hindi_Fiji = LocaleId.fromString("hin_FJ");
	static public final LocaleId Hmong = LocaleId.fromString("mww_CN");
	static public final LocaleId Hungarian = LocaleId.fromString("hu_HU");

	static public final LocaleId Iban = LocaleId.fromString("iba_MY");
	static public final LocaleId Icelandic = LocaleId.fromString("is_IS");
	static public final LocaleId Igbo = LocaleId.fromString("ib_NG");
	static public final LocaleId Ilocano = LocaleId.fromString("ilo_PH");
	static public final LocaleId Indonesian = LocaleId.fromString("id_ID");

	static public final LocaleId Kannada = LocaleId.fromString("kn_IN");
	static public final LocaleId Kazakh = LocaleId.fromString("kk_KZ");
	static public final LocaleId Kekchi = LocaleId.fromString("kek_GT");
	static public final LocaleId Khmer = LocaleId.fromString("khm_KH");
	static public final LocaleId Kirghiz = LocaleId.fromString("ky_KG");
	static public final LocaleId Kiribati = LocaleId.fromString("gil_KI");
	static public final LocaleId Korean = LocaleId.fromString("ko_KR");
	static public final LocaleId Kosraean = LocaleId.fromString("kos_FM");

	static public final LocaleId Lao = LocaleId.fromString("lo_LA");
	static public final LocaleId Latvian = LocaleId.fromString("lv_LV");
	static public final LocaleId Lingala = LocaleId.fromString("lin_CD");
	static public final LocaleId Lithuanian = LocaleId.fromString("lt_LT");

	static public final LocaleId Macedonian = LocaleId.fromString("mk_MK");
	static public final LocaleId Malagasy = LocaleId.fromString("msh_MG");
	static public final LocaleId Malay_Malaysia = LocaleId.fromString("ms_MY");
	static public final LocaleId Malayalam = LocaleId.fromString("ml_IN");
	static public final LocaleId Maltese = LocaleId.fromString("mt_MT");
	static public final LocaleId Mam = LocaleId.fromString("mvc_GT");
	static public final LocaleId Marshallese = LocaleId.fromString("mah_MH");
	static public final LocaleId Mongolian = LocaleId.fromString("mn_MN");

	static public final LocaleId Navajo = LocaleId.fromString("nav_US");
	static public final LocaleId Neomelanesian = LocaleId.fromString("tpi_PG"); // Tok Pisin
	static public final LocaleId Norwegian = LocaleId.fromString("no_NO");

	static public final LocaleId Palauan = LocaleId.fromString("pau_PW");
	static public final LocaleId Pohnpeian = LocaleId.fromString("pon_FM");
	static public final LocaleId Polish = LocaleId.fromString("pl_PL");

	static public final LocaleId Quechua = LocaleId.fromString("qul_BO"); // Bolivia
	static public final LocaleId Quichua = LocaleId.fromString("qur_EC"); // Ecuador

	static public final LocaleId Rarotongan = LocaleId.fromString("rar_CK");
	static public final LocaleId Romanian = LocaleId.fromString("ro_RO");
	static public final LocaleId Rwanda = LocaleId.fromString("kin_RW");

	static public final LocaleId Samoan = LocaleId.fromString("smo_WS");
	static public final LocaleId Serbian = LocaleId.fromString("sr_SP");
	static public final LocaleId Shona = LocaleId.fromString("sna_ZW");
	static public final LocaleId Slovak = LocaleId.fromString("sk_SK");
	static public final LocaleId Slovenian = LocaleId.fromString("sl_SI");
	static public final LocaleId South_Sotho = LocaleId.fromString("sot_LS"); // Sesotho
	static public final LocaleId Swahili = LocaleId.fromString("sw_KE");
	static public final LocaleId Swedish = LocaleId.fromString("sv_SE");

	static public final LocaleId Tagalog = LocaleId.fromString("tgl_PH");
	static public final LocaleId Tahitian = LocaleId.fromString("tah_PF");
	static public final LocaleId Thai = LocaleId.fromString("th_TH");
	static public final LocaleId Tongan = LocaleId.fromString("ton_TO");
	static public final LocaleId Tswana = LocaleId.fromString("tsn_BW");
	static public final LocaleId Turkish = LocaleId.fromString("tr_TR");

	static public final LocaleId Twi = LocaleId.fromString("twi_GH");

	static public final LocaleId Ukrainian = LocaleId.fromString("uk_UA");

	static public final LocaleId Vietnamese = LocaleId.fromString("vi_VN");

	static public final LocaleId Waray = LocaleId.fromString("war_PH"); // aka Samarnon, Warai

	static public final LocaleId Xhosa = LocaleId.fromString("xho_ZA");

	static public final LocaleId Yapese = LocaleId.fromString("yap_FM");
	static public final LocaleId Yoruba = LocaleId.fromString("yor_NG");
	static public final LocaleId Yupik = LocaleId.fromString("ess_US");

	static public final LocaleId Zulu = LocaleId.fromString("zu_ZA");
}
