/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization;

import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.steps.tokenization.ITokenizer;
import net.sf.okapi.steps.tokenization.Token;
import net.sf.okapi.steps.tokenization.Tokens;

public class RbbiTokenizer
implements ITokenizer {
    private static final String RBBI_RULES_NAME = "okapi~rbbi";
    private static final String RBBI_RULES_SUFFIX = ".brk";
    private final TreeMap<LocaleId, RuleBasedBreakIterator> iterators = new TreeMap();
    private RuleBasedBreakIterator iterator = null;
    private LocaleId language;
    private int start;
    private int end;
    private String text;

    @Override
    public boolean hasNext() {
        return this.end != -1;
    }

    @Override
    public Token next() {
        this.end = this.iterator.next();
        if (this.end == -1) {
            return null;
        }
        if (this.start >= this.end) {
            return null;
        }
        int tokenId = this.iterator.getRuleStatus();
        String value = this.text.substring(this.start, this.end);
        String name = Tokens.getTokenName(tokenId);
        String description = Tokens.getTokenDescription(tokenId);
        Token token = new Token(tokenId, value, name, description, this.start, this.end);
        this.start = this.end;
        return token;
    }

    @Override
    public void init(String text, LocaleId language) {
        this.language = language;
        this.text = text;
        if (Util.isEmpty(this.text)) {
            return;
        }
        if (this.iterators.containsKey(language)) {
            this.iterator = this.iterators.get(language);
        } else {
            try {
                Path temp = Files.createTempFile(RBBI_RULES_NAME, RBBI_RULES_SUFFIX, new FileAttribute[0]);
                String rules = StringUtil.readString(RbbiTokenizer.class.getResource("/rbbi.txt"));
                OutputStream out = Files.newOutputStream(temp, StandardOpenOption.CREATE);
                RuleBasedBreakIterator.compileRules((String)rules, (OutputStream)out);
                InputStream is = Files.newInputStream(temp, new OpenOption[0]);
                this.iterator = RuleBasedBreakIterator.getInstanceFromCompiledRules((InputStream)is);
            }
            catch (IOException | NullPointerException e) {
                throw new OkapiBadFilterInputException("Cannot load compiled break rules.", e);
            }
            this.iterators.put(language, this.iterator);
        }
        if (this.iterator == null) {
            return;
        }
        this.iterator.setText(this.text);
        this.end = this.start = this.iterator.first();
    }
}

