/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2.util;

import java.util.Iterator;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.filters.xliff2.model.XLIFF2NotesAnnotation;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import org.slf4j.LoggerFactory;

public class NotesMapper {
    private NotesMapper() {
        throw new IllegalStateException("Static Utility class");
    }

    public static void setNotes(IWithAnnotations sourceAnnotationsHolder, IWithNotes targetXliffNotesHolder) {
        for (IAnnotation iAnnotation : sourceAnnotationsHolder.getAnnotations()) {
            if (!(iAnnotation instanceof XLIFF2NotesAnnotation)) continue;
            XLIFF2NotesAnnotation xliffNoteAnnotation = (XLIFF2NotesAnnotation)iAnnotation;
            for (Note xliffNote : xliffNoteAnnotation) {
                targetXliffNotesHolder.addNote(xliffNote);
            }
        }
    }

    public static void setAnnotations(IWithNotes sourceXliffNotesHolder, IWithAnnotations targetAnnotationsHolder) {
        XLIFF2NotesAnnotation xliff2Notes = new XLIFF2NotesAnnotation();
        if (sourceXliffNotesHolder.getNoteCount() > 0) {
            for (Note note : sourceXliffNotesHolder.getNotes()) {
                xliff2Notes.add(note);
            }
            targetAnnotationsHolder.setAnnotation(xliff2Notes);
            NoteAnnotation xliffNotes = new NoteAnnotation();
            for (Note note : sourceXliffNotesHolder.getNotes()) {
                net.sf.okapi.common.annotation.Note n = new net.sf.okapi.common.annotation.Note();
                n.setNoteText(note.getText());
                n.setPriority(Note.Priority.fromInt(note.getPriority()));
                switch (note.getAppliesTo()) {
                    case SOURCE: {
                        n.setAnnotates(Note.Annotates.SOURCE);
                        break;
                    }
                    case TARGET: {
                        n.setAnnotates(Note.Annotates.TARGET);
                        break;
                    }
                    default: {
                        n.setAnnotates(Note.Annotates.GENERAL);
                    }
                }
                xliffNotes.add(n);
            }
            targetAnnotationsHolder.setAnnotation(xliffNotes);
        }
    }

    public static void setNotes(IWithAnnotations sourceAnnotationsHolder, StartFileData targetStartFileData) {
        Iterator<IAnnotation> iterator = sourceAnnotationsHolder.getAnnotations().iterator();
        if (iterator.hasNext()) {
            LoggerFactory.getLogger(NotesMapper.class).warn("Annotations could not be stored as Notes in the StartFileData object. Annotations that you want stored there must go in a DocumentPart.");
        }
    }
}

