/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextPartComparator;
import net.sf.okapi.common.resource.WhitespaceStrategy;
import net.sf.okapi.filters.xliff2.MetadataSkeleton;
import net.sf.okapi.filters.xliff2.XLIFF2FilterWriter;
import net.sf.okapi.filters.xliff2.Xliff2Skeleton;
import net.sf.okapi.filters.xliff2.util.NotesMapper;
import net.sf.okapi.filters.xliff2.util.PropertiesMapper;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkpToX2Converter {
    private static final Map<TextFragment.TagType, TagType> codeTagTypeMap = new HashMap<TextFragment.TagType, TagType>();
    private static final String ID = "id";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<Event> handleEvent(net.sf.okapi.common.Event okapiEvent, XLIFF2FilterWriter xliff2FilterWriter) {
        net.sf.okapi.common.EventType eventType = okapiEvent.getEventType();
        switch (eventType) {
            case START_DOCUMENT: {
                return this.startDocument(okapiEvent.getStartDocument(), xliff2FilterWriter);
            }
            case END_DOCUMENT: {
                return this.endDocument(okapiEvent.getEnding());
            }
            case START_SUBDOCUMENT: {
                return this.startSubDocument(okapiEvent.getStartSubDocument());
            }
            case END_SUBDOCUMENT: {
                return this.endSubDocument();
            }
            case START_GROUP: {
                return this.startGroup(okapiEvent.getStartGroup());
            }
            case END_GROUP: {
                return this.endGroup(okapiEvent.getEndGroup());
            }
            case TEXT_UNIT: {
                return this.textUnit(okapiEvent.getTextUnit(), xliff2FilterWriter.getTargetLocale());
            }
            case DOCUMENT_PART: {
                return this.documentPart(okapiEvent.getDocumentPart());
            }
            case CUSTOM: {
                return Collections.emptyList();
            }
        }
        throw new OkapiException("Event " + (Object)((Object)okapiEvent.getEventType()) + " is not implemented in XLIFF 2.0 Filter Writer");
    }

    private List<Event> documentPart(DocumentPart documentPart) {
        if (documentPart.getSkeleton() != null) {
            if (documentPart.getSkeleton() instanceof MetadataSkeleton) {
                MidFileData xliffMidFileData = new MidFileData();
                xliffMidFileData.setMetadata(((MetadataSkeleton)documentPart.getSkeleton()).getMetaData());
                Event event = new Event(EventType.MID_FILE, null, xliffMidFileData);
                NotesMapper.setNotes((IWithAnnotations)documentPart, xliffMidFileData);
                return Collections.singletonList(event);
            }
            if (documentPart.getSkeleton() instanceof Xliff2Skeleton) {
                Event event = new Event(EventType.SKELETON, null, ((Xliff2Skeleton)documentPart.getSkeleton()).getXliff2Skeleton());
                return Collections.singletonList(event);
            }
        }
        MidFileData xliffMidFileData = new MidFileData();
        Event event = new Event(EventType.MID_FILE, null, xliffMidFileData);
        NotesMapper.setNotes((IWithAnnotations)documentPart, xliffMidFileData);
        return Collections.singletonList(event);
    }

    private List<Event> textUnit(ITextUnit okapiTextUnit, LocaleId targetLocale) {
        TextContainer okapiTargets;
        HashSet<String> sourceCodeIds = new HashSet<String>();
        HashSet<String> targetCodeIds = new HashSet<String>();
        Unit xliffTextUnit = new Unit(okapiTextUnit.getId());
        Event event = new Event(EventType.TEXT_UNIT, null, xliffTextUnit);
        Set<LocaleId> availableTargetLocales = okapiTextUnit.getTargetLocales();
        xliffTextUnit.setId(okapiTextUnit.getId());
        xliffTextUnit.setName(okapiTextUnit.getName());
        xliffTextUnit.setType(okapiTextUnit.getType());
        xliffTextUnit.setTranslate(okapiTextUnit.isTranslatable());
        xliffTextUnit.setPreserveWS(okapiTextUnit.preserveWhitespaces());
        if (okapiTextUnit.getSkeleton() != null) {
            xliffTextUnit.setMetadata(((MetadataSkeleton)okapiTextUnit.getSkeleton()).getMetaData());
        }
        PropertiesMapper.setTextUnitProperties(okapiTextUnit, xliffTextUnit);
        NotesMapper.setNotes((IWithAnnotations)okapiTextUnit, xliffTextUnit);
        TextContainer okapiSources = okapiTextUnit.getSource();
        TextPartComparator cmp = new TextPartComparator();
        boolean[] matched = new boolean[]{};
        if (targetLocale != null && availableTargetLocales.contains(targetLocale)) {
            okapiTargets = okapiTextUnit.getTarget(targetLocale);
            if (okapiTargets.count() != 0 && okapiSources.count() != okapiTargets.count()) {
                this.logger.warn("Target count doesn't match source count. Misalignment is possible.");
            }
            matched = new boolean[okapiTargets.count()];
            Arrays.fill(matched, false);
        } else {
            okapiTargets = null;
        }
        for (TextPart okapiSourcePart : okapiSources.getParts()) {
            TextPart okapiTargetPart;
            Part xliffPart;
            if (okapiSourcePart.isSegment()) {
                xliffPart = xliffTextUnit.appendSegment();
                if (xliffPart.getSource() == null) {
                    xliffPart.setSource("");
                }
            } else {
                xliffPart = xliffTextUnit.appendIgnorable();
            }
            if (okapiSourcePart.getWhitespaceStrategy() == WhitespaceStrategy.INHERIT) {
                xliffPart.setPreserveWS(okapiTextUnit.preserveWhitespaces());
            } else {
                xliffPart.setPreserveWS(okapiSourcePart.preserveWhitespaces());
            }
            xliffPart.setId(okapiSourcePart.getOriginalId());
            this.copyOver(okapiSourcePart.getContent(), xliffPart.getSource(), sourceCodeIds);
            if (okapiTargets != null && (okapiTargetPart = Util.findMatch(okapiSourcePart, okapiTargets.getParts(), matched, cmp)) != null) {
                if (xliffPart.getTarget() == null) {
                    xliffPart.setTarget("");
                }
                this.copyOver(okapiTargetPart.getContent(), xliffPart.getTarget(), targetCodeIds);
            }
            PropertiesMapper.setPartProperties(okapiSourcePart, xliffPart);
        }
        return Collections.singletonList(event);
    }

    private List<Event> endGroup(Ending endGroup) {
        Event event = new Event(EventType.END_GROUP, null);
        return Collections.singletonList(event);
    }

    private List<Event> startGroup(StartGroup startGroup) {
        Property propertyId = startGroup.getProperty(ID);
        String propertyIdString = propertyId == null ? null : propertyId.getValue();
        StartGroupData startGroupData = new StartGroupData(propertyIdString);
        startGroupData.setId(startGroup.getId());
        startGroupData.setTranslate(startGroup.isTranslatable());
        Event event = new Event(EventType.START_GROUP, null, startGroupData);
        if (startGroup.getSkeleton() != null) {
            startGroupData.setMetadata(((MetadataSkeleton)startGroup.getSkeleton()).getMetaData());
        }
        PropertiesMapper.setGroupProperties(startGroup, startGroupData);
        NotesMapper.setNotes((IWithAnnotations)startGroup, startGroupData);
        return Collections.singletonList(event);
    }

    private List<Event> startDocument(StartDocument startDocument, XLIFF2FilterWriter xliff2FilterWriter) {
        Event startDocumentEvent = new Event(EventType.START_DOCUMENT, null);
        LocaleId locale = startDocument.getLocale();
        Property xliffVersionProperty = startDocument.getProperty("version");
        String xliffVersion = xliffVersionProperty != null ? xliffVersionProperty.getValue() : "2.0";
        StartXliffData startXliffData = new StartXliffData(xliffVersion);
        startXliffData.setSourceLanguage(startDocument.getLocale().toString());
        Event startXliffEvent = new Event(EventType.START_XLIFF, null, startXliffData);
        xliff2FilterWriter.initializeWriter(locale);
        PropertiesMapper.setStartXliffProperties(startDocument, startXliffData);
        return Arrays.asList(startDocumentEvent, startXliffEvent);
    }

    private List<Event> endDocument(Ending okapiEvent) {
        Event endXliffEvent = new Event(EventType.END_XLIFF, null);
        Event endDocumentEvent = new Event(EventType.END_DOCUMENT, null);
        return Arrays.asList(endXliffEvent, endDocumentEvent);
    }

    private List<Event> startSubDocument(StartSubDocument okapiStartSubDoc) {
        ArrayList<Event> events = new ArrayList<Event>();
        StartFileData startFileData = new StartFileData(okapiStartSubDoc.getId());
        startFileData.setOriginal(okapiStartSubDoc.getName());
        startFileData.setId(okapiStartSubDoc.getId());
        startFileData.setTranslate(okapiStartSubDoc.isTranslatable());
        startFileData.setOriginal(okapiStartSubDoc.getName());
        PropertiesMapper.setStartFileProperties(okapiStartSubDoc, startFileData);
        NotesMapper.setNotes((IWithAnnotations)okapiStartSubDoc, startFileData);
        Event startFileEvent = new Event(EventType.START_FILE, null, startFileData);
        events.add(startFileEvent);
        return events;
    }

    private List<Event> endSubDocument() {
        Event event = new Event(EventType.END_FILE, null);
        return Collections.singletonList(event);
    }

    private void copyOver(TextFragment source, Fragment out, Set<String> existingCodeIds) {
        String codedText = source.getCodedText();
        int nextCodeIndex = -1;
        int nextCodePosition = -1;
        if (source.hasCode()) {
            nextCodeIndex = 0;
            nextCodePosition = source.getCodePosition(nextCodeIndex);
        }
        for (int i = 0; i < codedText.length(); ++i) {
            char c = codedText.charAt(i);
            if (nextCodePosition == i) {
                Tag xliff2Tag;
                char codePosition = codedText.charAt(i + 1);
                Code okapiCode = source.getCode(codePosition);
                TagType tagType = codeTagTypeMap.get((Object)okapiCode.getTagType());
                String id = okapiCode.getOriginalId();
                if (id == null) {
                    id = String.valueOf(okapiCode.getId());
                    this.logger.warn("Original code id was null in segment: {}. Using Okapi code integer id instead: {}", (Object)source, (Object)id);
                }
                if (tagType.equals((Object)TagType.CLOSING) || tagType.equals((Object)TagType.STANDALONE)) {
                    if (existingCodeIds.contains(id)) {
                        throw new OkapiMergeException("Tried writing placeholder to XLIFF 2 with the same ID as another placeholder in the same text unit. Previous ID: " + okapiCode.getId() + " | XLIFF 2 ID: " + id + " | Placeholder: " + okapiCode);
                    }
                    existingCodeIds.add(id);
                }
                if (okapiCode.hasProperty("mtag")) {
                    xliff2Tag = new MTag(id, okapiCode.getType());
                    ((MTag)xliff2Tag).setTagType(okapiCode.getTagType() == TextFragment.TagType.OPENING ? TagType.OPENING : TagType.CLOSING);
                    PropertiesMapper.setCodeProperties(okapiCode, (MTag)xliff2Tag);
                } else {
                    xliff2Tag = new CTag(tagType, id, okapiCode.getData());
                    ((CTag)xliff2Tag).setCanCopy(okapiCode.isCloneable());
                    ((CTag)xliff2Tag).setCanDelete(okapiCode.isDeleteable());
                    ((CTag)xliff2Tag).setData(okapiCode.getData());
                    ((CTag)xliff2Tag).setDisp(okapiCode.getDisplayText());
                    if (okapiCode.getType() != null && !okapiCode.getType().equals("null")) {
                        try {
                            String type = okapiCode.getType();
                            if (type.startsWith("x-")) {
                                type = type.substring(2, type.length());
                            }
                            xliff2Tag.setType(type);
                        }
                        catch (InvalidParameterException e) {
                            LoggerFactory.getLogger(PropertiesMapper.class).debug("Could net set CTag type of {}: {}", (Object)xliff2Tag, (Object)e.getMessage());
                        }
                    }
                    PropertiesMapper.setCodeProperties(okapiCode, (CTag)xliff2Tag);
                }
                out.append(xliff2Tag);
                nextCodePosition = source.getCodePosition(++nextCodeIndex);
                ++i;
                continue;
            }
            out.append(c);
        }
    }

    static {
        codeTagTypeMap.put(TextFragment.TagType.OPENING, TagType.OPENING);
        codeTagTypeMap.put(TextFragment.TagType.CLOSING, TagType.CLOSING);
        codeTagTypeMap.put(TextFragment.TagType.PLACEHOLDER, TagType.STANDALONE);
    }
}

