/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

interface WorksheetConfiguration {
    public boolean matches(String var1);

    public Set<Integer> excludedRows();

    public Set<String> excludedColumns();

    public Set<Integer> metadataRows();

    public Set<String> metadataColumns();

    public <T> T writtenTo(Output<T> var1);

    public static interface Output<T> {
        public T writtenWith(Pattern var1, Set<Integer> var2, Set<String> var3, Set<Integer> var4, Set<String> var5);
    }

    public static final class Default
    implements WorksheetConfiguration {
        private final Pattern namePattern;
        private final Set<Integer> excludedRows;
        private final Set<String> excludedColumns;
        private final Set<Integer> metadataRows;
        private final Set<String> metadataColumns;

        Default(String nameString, List<Integer> excludedRows, List<String> excludedColumns, List<Integer> metadataRows, List<String> metadataColumns) {
            this(nameString, new LinkedHashSet<Integer>(excludedRows), new LinkedHashSet<String>(excludedColumns), new LinkedHashSet<Integer>(metadataRows), new LinkedHashSet<String>(metadataColumns));
        }

        Default(String nameString, Set<Integer> excludedRows, Set<String> excludedColumns, Set<Integer> metadataRows, Set<String> metadataColumns) {
            this(Pattern.compile(nameString), excludedRows, excludedColumns, metadataRows, metadataColumns);
        }

        Default(Pattern namePattern, Set<Integer> excludedRows, Set<String> excludedColumns, Set<Integer> metadataRows, Set<String> metadataColumns) {
            this.namePattern = namePattern;
            this.excludedRows = excludedRows;
            this.excludedColumns = excludedColumns;
            this.metadataRows = metadataRows;
            this.metadataColumns = metadataColumns;
        }

        @Override
        public boolean matches(String worksheetName) {
            return this.namePattern.matcher(worksheetName).matches();
        }

        @Override
        public Set<Integer> excludedRows() {
            return this.excludedRows;
        }

        @Override
        public Set<String> excludedColumns() {
            return this.excludedColumns;
        }

        @Override
        public Set<Integer> metadataRows() {
            return this.metadataRows;
        }

        @Override
        public Set<String> metadataColumns() {
            return this.metadataColumns;
        }

        @Override
        public <T> T writtenTo(Output<T> output) {
            return output.writtenWith(this.namePattern, this.excludedRows, this.excludedColumns, this.metadataRows, this.metadataColumns);
        }
    }
}

