/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellReference;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MetadataContext;
import net.sf.okapi.filters.openxml.SharedStrings;
import net.sf.okapi.filters.openxml.WorksheetFragments;

interface Worksheet {
    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public void writeWith(XMLEventWriter var1) throws XMLStreamException;

    public static class Default
    implements Worksheet {
        private static final String SHEET_VIEW = "sheetView";
        private static final String CELL = "c";
        private static final String VALUE = "v";
        private static final String INLINE_STRING = "is";
        private static final QName CELL_LOCATION_REFERENCE = new QName("r");
        private static final QName CELL_TYPE = new QName("t");
        private static final String CELL_TYPE_INLINE_STRING = "inlineStr";
        private static final String CELL_TYPE_SHARED_STRING = "s";
        private static final QName CELL_STYLE = new QName("s");
        private static final int FAKE_INDEX = -1;
        private static final Set<Character> EXTRA_WHITESPACES = new HashSet<Character>(Arrays.asList(Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final SharedStrings sharedStrings;
        private final ExcelStyles styles;
        private final String name;
        private final WorksheetFragments fragments;
        private Set<Integer> excludedRows;
        private Set<String> excludedColumns;
        private Set<Integer> metadataRows;
        private Set<String> metadataColumns;
        private CellReferencesRange cellReferencesRange;
        private MarkupBuilder markupBuilder;
        private ListIterator<XMLEvent> iterator;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, SharedStrings sharedStrings, ExcelStyles styles, String name, WorksheetFragments fragments) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.sharedStrings = sharedStrings;
            this.styles = styles;
            this.name = name;
            this.fragments = fragments;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.fragments.readWith(reader);
            this.excludedRows = new HashSet<Integer>(this.conditionalParameters.worksheetConfigurations().excludedRowsFor(this.name));
            this.excludedRows.addAll(this.fragments.hiddenRows());
            this.metadataRows = this.conditionalParameters.worksheetConfigurations().metadataRowsFor(this.name);
            this.excludedRows.addAll(this.metadataRows);
            this.excludedColumns = new HashSet<String>(this.conditionalParameters.worksheetConfigurations().excludedColumnsFor(this.name));
            this.excludedColumns.addAll(this.fragments.hiddenColumns());
            this.metadataColumns = this.conditionalParameters.worksheetConfigurations().metadataColumnsFor(this.name);
            this.excludedColumns.addAll(this.metadataColumns);
            this.markupBuilder = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            this.iterator = this.fragments.events().listIterator();
            while (this.iterator.hasNext()) {
                EndElement ee;
                XMLEvent e = this.iterator.next();
                if (e.isStartElement()) {
                    StartElement se = e.asStartElement();
                    if (SHEET_VIEW.equals(se.getName().getLocalPart())) {
                        this.markupBuilder.add(new MarkupComponent.Start(this.eventFactory, se));
                        continue;
                    }
                    if (CELL.equals(se.getName().getLocalPart())) {
                        this.readCell(se);
                        continue;
                    }
                } else if (e.isEndElement() && SHEET_VIEW.equals((ee = e.asEndElement()).getName().getLocalPart())) {
                    this.markupBuilder.add(new MarkupComponent.End(ee));
                    continue;
                }
                this.markupBuilder.add(e);
            }
        }

        private void readCell(StartElement startElement) {
            Attribute typeAttr = startElement.getAttributeByName(CELL_TYPE);
            if (typeAttr != null && (CELL_TYPE_INLINE_STRING.equals(typeAttr.getValue()) || CELL_TYPE_SHARED_STRING.equals(typeAttr.getValue()))) {
                boolean excluded;
                if (CELL_TYPE_INLINE_STRING.equals(typeAttr.getValue())) {
                    this.markupBuilder.add(this.newCellStartElement(startElement, typeAttr));
                } else {
                    this.markupBuilder.add(startElement);
                }
                this.cellReferencesRange = this.cellReferencesRange(new CellReference(startElement.getAttributeByName(CELL_LOCATION_REFERENCE).getValue()));
                boolean bl = excluded = !this.cellReferencesRange.partialMatch(this.excludedRows, this.excludedColumns) || this.styleExcluded(startElement);
                while (this.iterator.hasNext()) {
                    XMLEvent e = this.iterator.next();
                    if (e.isEndElement() && e.asEndElement().getName().equals(startElement.getName())) {
                        this.markupBuilder.add(e);
                        break;
                    }
                    if (!e.isStartElement()) {
                        this.markupBuilder.add(e);
                        continue;
                    }
                    StartElement se = e.asStartElement();
                    if (VALUE.equals(se.getName().getLocalPart())) {
                        this.readValue(se, excluded);
                        continue;
                    }
                    if (INLINE_STRING.equals(se.getName().getLocalPart())) {
                        this.readInlineString(se, excluded);
                        continue;
                    }
                    this.markupBuilder.add(e);
                }
            } else {
                this.markupBuilder.addAll(this.currentAndSiblingEventsOf(startElement));
            }
        }

        private StartElement newCellStartElement(StartElement startElement, Attribute attribute) {
            ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute a = iterator.next();
                if (CELL_TYPE.equals(a.getName())) {
                    newAttributes.add(this.eventFactory.createAttribute(attribute.getName(), CELL_TYPE_SHARED_STRING));
                    continue;
                }
                newAttributes.add(a);
            }
            return this.eventFactory.createStartElement(startElement.getName(), newAttributes.iterator(), startElement.getNamespaces());
        }

        private CellReferencesRange cellReferencesRange(CellReference cellReference) {
            return this.fragments.cellReferencesRanges().stream().filter(r -> r.first().equals(cellReference)).findFirst().orElse(new CellReferencesRange(cellReference));
        }

        private boolean styleExcluded(StartElement startElement) {
            boolean excluded = false;
            Attribute styleAttr = startElement.getAttributeByName(CELL_STYLE);
            if (styleAttr != null) {
                int styleIndex = Integer.parseUnsignedInt(styleAttr.getValue());
                ExcelStyles.CellStyle style = this.styles.getCellStyle(styleIndex);
                for (String excludedColor : this.conditionalParameters.tsExcelExcludedColors) {
                    if (!style.fill.matchesColor(excludedColor)) continue;
                    excluded = true;
                    break;
                }
            }
            return excluded;
        }

        private void readValue(StartElement startElement, boolean excluded) {
            this.markupBuilder.add(startElement);
            while (this.iterator.hasNext()) {
                XMLEvent e = this.iterator.next();
                if (e.isEndElement() && e.asEndElement().getName().equals(startElement.getName())) {
                    this.markupBuilder.add(e);
                    break;
                }
                if (!e.isCharacters()) {
                    this.markupBuilder.add(e);
                    continue;
                }
                String s = e.asCharacters().getData().trim();
                if (s.isEmpty() || s.chars().mapToObj(c -> Character.valueOf((char)c)).allMatch(c -> EXTRA_WHITESPACES.contains(c))) {
                    this.markupBuilder.add(e);
                    continue;
                }
                int origIndex = Default.sharedStringIndex(s);
                int newIndex = this.sharedStrings.nextIndex();
                this.sharedStrings.add(new SharedStrings.Item(origIndex, newIndex, Collections.emptyList(), this.name, this.cellReferencesRange, excluded, this.metadataContext()));
                this.markupBuilder.add(this.eventFactory.createCharacters(String.valueOf(newIndex)));
            }
        }

        private static int sharedStringIndex(String value) {
            try {
                return Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Unexpected shared string index '" + value + "'");
            }
        }

        private void readInlineString(StartElement startElement, boolean excluded) {
            XMLEvent e;
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            while (!(!this.iterator.hasNext() || (e = this.iterator.next()).isEndElement() && e.asEndElement().getName().equals(startElement.getName()))) {
                events.add(e);
            }
            int newIndex = this.sharedStrings.nextIndex();
            this.sharedStrings.add(new SharedStrings.Item(-1, newIndex, events, this.name, this.cellReferencesRange, excluded, this.metadataContext()));
            this.markupBuilder.add(this.eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), VALUE));
            this.markupBuilder.add(this.eventFactory.createCharacters(String.valueOf(newIndex)));
            this.markupBuilder.add(this.eventFactory.createEndElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), VALUE));
        }

        private List<XMLEvent> currentAndSiblingEventsOf(StartElement startElement) {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(startElement);
            while (this.iterator.hasNext()) {
                XMLEvent e = this.iterator.next();
                events.add(e);
                if (!e.isEndElement() || !e.asEndElement().getName().equals(startElement.getName())) continue;
                break;
            }
            return events;
        }

        private MetadataContext metadataContext() {
            boolean metadataRow = this.cellReferencesRange.rows().stream().anyMatch(r -> this.metadataRows.contains(r));
            boolean metadataColumn = this.cellReferencesRange.columns().stream().anyMatch(c -> this.metadataColumns.contains(c));
            MetadataContext context = metadataRow && metadataColumn ? MetadataContext.ROW_AND_COLUMN : (metadataRow ? MetadataContext.ROW : (metadataColumn ? MetadataContext.COLUMN : MetadataContext.NONE));
            return context;
        }

        @Override
        public void writeWith(XMLEventWriter writer) throws XMLStreamException {
            for (XMLEvent event : this.markupBuilder.build().getEvents()) {
                writer.add(event);
            }
        }
    }
}

