/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.annotation.XLIFFContextGroup;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.MetadataContext;
import net.sf.okapi.filters.openxml.SharedStrings;
import net.sf.okapi.filters.openxml.SharedStringsDenormalizer;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemParser;
import net.sf.okapi.filters.openxml.StringItemTextUnitMapper;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class SharedStringsPart
extends StyledTextPart {
    private static final String EMPTY = "";
    private static final String ROW_METADATA = "row-metadata";
    private static final String WORKSHEETS = "worksheets";
    private static final String ROWS = "rows";
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final SharedStrings sharedStrings;
    private int sharedStringIndex = 0;
    private IdGenerator worksheetGroupIds;
    private IdGenerator rowGroupIds;
    private StartGroup worksheetStartGroup;
    private StartGroup rowStartGroup;
    private ContextTypes contextTypes;
    private List<XLIFFContextGroup.Context> groupContexts;

    SharedStringsPart(Document.General generalDocument, ZipEntry entry, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, EncoderManager encoderManager, IFilter subfilter, SharedStrings sharedStrings) {
        super(generalDocument, entry, styleDefinitions, styleOptimisation);
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.sharedStrings = sharedStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event open() throws IOException, XMLStreamException {
        this.documentId = this.generalDocument.documentId();
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.sourceLocale = this.generalDocument.sourceLocale();
        this.worksheetGroupIds = new IdGenerator(WORKSHEETS, "sg");
        SharedStringsDenormalizer deno = new SharedStringsDenormalizer(this.generalDocument.eventFactory(), this.sharedStrings);
        XMLEventReader reader = this.generalDocument.inputFactory().createXMLEventReader(new InputStreamReader(this.generalDocument.inputStreamFor(this.entry), StandardCharsets.UTF_8));
        File rewrittenStringsTable = File.createTempFile("sharedStrings", ".xml");
        XMLEventWriter writer = this.generalDocument.outputFactory().createXMLEventWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rewrittenStringsTable), StandardCharsets.UTF_8));
        deno.process(reader, writer);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(rewrittenStringsTable));
        this.eventReader = this.generalDocument.inputFactory().createXMLEventReader(is);
        try {
            this.process();
        }
        finally {
            if (this.eventReader != null) {
                this.eventReader.close();
            }
            rewrittenStringsTable.delete();
        }
        return this.createStartSubDocumentEvent(this.documentId, this.subDocumentId);
    }

    private void process() throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent e = this.eventReader.nextEvent();
            if (!XMLEventHelpers.isStringItemStartEvent(e)) {
                this.addEventToDocumentPart(e);
                continue;
            }
            this.flushDocumentPart();
            if (this.sharedStrings.worksheetStartsAt(this.sharedStringIndex)) {
                this.endRowGroup();
                this.endWorksheetGroup();
                this.initRowGroupIds();
                this.startWorksheetGroup();
                this.startRowGroup();
            } else if (this.sharedStrings.rowStartsAt(this.sharedStringIndex)) {
                this.endRowGroup();
                if (!this.rowGroupIdsInitialised()) {
                    this.initRowGroupIds();
                }
                this.startRowGroup();
            }
            StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.eventReader, this.generalDocument.eventFactory(), this.generalDocument.conditionalParameters());
            StringItem stringItem = new StringItemParser(startElementContext, this.nestedBlockId, this.styleDefinitions, this.styleOptimisation).parse();
            stringItem.optimiseStyles();
            MetadataContext metadataContext = this.sharedStrings.metadataContextAt(this.sharedStringIndex);
            if (MetadataContext.ROW_AND_COLUMN == metadataContext) {
                this.addContextTypeFrom(stringItem);
            } else if (MetadataContext.COLUMN == metadataContext) {
                this.addGroupContextFrom(stringItem);
            }
            if (!this.sharedStrings.visibleAt(this.sharedStringIndex)) {
                this.addBlockChunksToDocumentPart(stringItem.getChunks());
                this.flushDocumentPart();
                ++this.sharedStringIndex;
                continue;
            }
            List<ITextUnit> textUnits = new StringItemTextUnitMapper(this.textUnitId, this.generalDocument.eventFactory(), stringItem, this.sharedStrings.worksheetAt(this.sharedStringIndex), this.sharedStrings.cellReferencesRangeAt(this.sharedStringIndex).first()).map();
            if (textUnits.isEmpty()) {
                this.addBlockChunksToDocumentPart(stringItem.getChunks());
                this.flushDocumentPart();
            } else if (this.subfilter != null && !stringItem.isStyled()) {
                this.addSubfilteredEvents(textUnits);
            } else {
                this.addTextUnitEvents(textUnits);
            }
            ++this.sharedStringIndex;
        }
        this.endRowGroup();
        this.endWorksheetGroup();
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private boolean rowGroupIdsInitialised() {
        return null != this.rowGroupIds;
    }

    private void initRowGroupIds() {
        String worksheet = this.sharedStrings.worksheetAt(this.sharedStringIndex);
        this.rowGroupIds = new IdGenerator(worksheet.concat(ROWS), "sg");
    }

    private boolean worksheetGroupInitialised() {
        return null != this.worksheetStartGroup;
    }

    private void startWorksheetGroup() {
        this.contextTypes = new ContextTypes((Set)this.generalDocument.conditionalParameters().worksheetConfigurations().metadataColumnsFor(this.sharedStrings.worksheetAt(this.sharedStringIndex)));
        this.worksheetStartGroup = new StartGroup(EMPTY, this.worksheetGroupIds.createId());
        this.worksheetStartGroup.setName(this.sharedStrings.worksheetAt(this.sharedStringIndex));
        this.filterEvents.add(new Event(EventType.START_GROUP, this.worksheetStartGroup));
    }

    private void endWorksheetGroup() {
        if (this.worksheetGroupInitialised()) {
            this.filterEvents.add(new Event(EventType.END_GROUP, new Ending(this.worksheetStartGroup.getId())));
            this.worksheetStartGroup = null;
        }
    }

    boolean rowGroupInitialised() {
        return null != this.rowStartGroup;
    }

    private void startRowGroup() {
        this.groupContexts = new LinkedList<XLIFFContextGroup.Context>();
        this.rowStartGroup = new StartGroup(EMPTY, this.rowGroupIds.createId());
        this.rowStartGroup.setName(String.valueOf(this.sharedStrings.cellReferencesRangeAt(this.sharedStringIndex).first().row()));
        this.filterEvents.add(new Event(EventType.START_GROUP, this.rowStartGroup));
    }

    private void endRowGroup() {
        if (this.rowGroupInitialised()) {
            if (!this.groupContexts.isEmpty()) {
                this.rowStartGroup.setAnnotation(new XLIFFContextGroup(this.encoderManager, ROW_METADATA, null, null, this.groupContexts));
            }
            this.filterEvents.add(new Event(EventType.END_GROUP, new Ending(this.rowStartGroup.getId())));
            this.rowStartGroup = null;
        }
    }

    private void addContextTypeFrom(StringItem stringItem) {
        this.contextTypes.add(this.sharedStrings.cellReferencesRangeAt(this.sharedStringIndex), stringItem.text());
    }

    private void addGroupContextFrom(StringItem stringItem) {
        XLIFFContextGroup.Context context = new XLIFFContextGroup.Context(this.encoderManager, this.contextTypes.valueFor(this.sharedStrings.cellReferencesRangeAt(this.sharedStringIndex)), null, null);
        context.value(stringItem.text());
        this.groupContexts.add(context);
    }

    private void addTextUnitEvents(List<ITextUnit> textUnits) {
        for (ITextUnit tu : textUnits) {
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
        }
    }

    private void addSubfilteredEvents(List<ITextUnit> textUnits) {
        int subfilterIndex = 0;
        for (ITextUnit tu : textUnits) {
            SubFilter sf = new SubFilter(this.subfilter, this.encoderManager.getEncoder(), ++subfilterIndex, tu.getId(), tu.getName());
            Throwable throwable = null;
            try {
                this.filterEvents.addAll(sf.getEvents(new RawDocument(tu.getSource().getFirstContent().getText(), this.sourceLocale)));
                this.filterEvents.add(sf.createRefEvent(tu));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sf == null) continue;
                if (throwable != null) {
                    try {
                        sf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sf.close();
            }
        }
    }

    private static class ContextTypes {
        private static final String DELIMITER = ";";
        private final Set<String> metadataColumns;
        private final Map<CellReferencesRange, String> values;

        private ContextTypes(Set<String> metadataColumns) {
            this(metadataColumns, new LinkedHashMap<CellReferencesRange, String>());
        }

        private ContextTypes(Set<String> metadataColumns, Map<CellReferencesRange, String> values) {
            this.metadataColumns = metadataColumns;
            this.values = values;
        }

        void add(CellReferencesRange cellReferencesRange, String value) {
            this.values.put(cellReferencesRange, value);
        }

        String valueFor(CellReferencesRange cellReferencesRange) {
            String value = this.values.entrySet().stream().filter(e -> ((CellReferencesRange)e.getKey()).anyMatch(Collections.emptySet(), cellReferencesRange.columns())).map(e -> (String)e.getValue()).collect(Collectors.joining(DELIMITER));
            return value.isEmpty() ? cellReferencesRange.columnMatches(this.metadataColumns).stream().collect(Collectors.joining(DELIMITER)) : value;
        }
    }
}

