/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.MetadataContext;

final class SharedStrings {
    private static final int START_INDEX = 0;
    private int nextIndex = 0;
    private final ArrayList<Item> items = new ArrayList();

    SharedStrings() {
    }

    int nextIndex() {
        return this.nextIndex;
    }

    void add(Item item) {
        this.items.ensureCapacity(item.newIndex() + 1);
        this.items.add(item.newIndex(), item);
        ++this.nextIndex;
    }

    List<Item> items() {
        return this.items;
    }

    boolean worksheetStartsAt(int index) {
        if (0 == index) {
            return true;
        }
        return !this.items.get(index - 1).worksheet().equals(this.items.get(index).worksheet());
    }

    String worksheetAt(int index) {
        return this.items.get(index).worksheet();
    }

    CellReferencesRange cellReferencesRangeAt(int index) {
        return this.items.get(index).cellReferencesRange();
    }

    boolean rowStartsAt(int index) {
        return this.items.get(index - 1).cellReferencesRange().first().row() != this.items.get(index).cellReferencesRange().first().row();
    }

    boolean visibleAt(int index) {
        return !this.items.get(index).excluded();
    }

    MetadataContext metadataContextAt(int index) {
        return this.items.get(index).metadataContext();
    }

    static final class Item {
        private final int origIndex;
        private final int newIndex;
        private final List<XMLEvent> events;
        private final String worksheet;
        private final CellReferencesRange cellReferencesRange;
        private final boolean excluded;
        private final MetadataContext metadataContext;

        Item(int origIndex, int newIndex, List<XMLEvent> events, String worksheet, CellReferencesRange cellReferencesRange, boolean excluded, MetadataContext metadataContext) {
            this.origIndex = origIndex;
            this.newIndex = newIndex;
            this.events = events;
            this.worksheet = worksheet;
            this.cellReferencesRange = cellReferencesRange;
            this.excluded = excluded;
            this.metadataContext = metadataContext;
        }

        int originalIndex() {
            return this.origIndex;
        }

        int newIndex() {
            return this.newIndex;
        }

        List<XMLEvent> events() {
            return this.events;
        }

        String worksheet() {
            return this.worksheet;
        }

        CellReferencesRange cellReferencesRange() {
            return this.cellReferencesRange;
        }

        boolean excluded() {
            return this.excluded;
        }

        MetadataContext metadataContext() {
            return this.metadataContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Item)) {
                return false;
            }
            Item e = (Item)o;
            return this.origIndex == e.origIndex && this.newIndex == e.newIndex;
        }

        public int hashCode() {
            return Objects.hash(this.origIndex, this.newIndex);
        }

        public String toString() {
            return "Item(" + this.origIndex + " -> " + this.newIndex + ", " + (this.events.isEmpty() ? "[]" : "[" + this.events.stream().map(e -> e.toString()).collect(Collectors.joining(", ")) + "]") + ", " + this.worksheet + ", " + this.cellReferencesRange + ", " + (this.excluded ? "excluded" : "visible") + ", " + (Object)((Object)this.metadataContext) + ")";
        }
    }
}

