/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEvents;

interface MarkupComponent
extends XMLEvents {
    public void apply(FontMappings var1);

    public static boolean isSheetViewStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "sheetView".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isAlignmentEmptyElement(MarkupComponent markupComponent) {
        return markupComponent instanceof EmptyElement && "alignment".equals(((EmptyElement)markupComponent).getName().getLocalPart());
    }

    public static boolean isPresentationStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "presentation".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isTableStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "tbl".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isTextBodyStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "txBody".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isParagraphStart(MarkupComponent markupComponent) {
        return markupComponent instanceof ParagraphStart;
    }

    public static boolean isWordStylesStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "styles".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordStylesEnd(MarkupComponent markupComponent) {
        return markupComponent instanceof End && "styles".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordDocumentDefaultsStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "docDefaults".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordDocumentDefaultsEnd(MarkupComponent markupComponent) {
        return markupComponent instanceof End && "docDefaults".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordStyleStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "style".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordStyleEnd(MarkupComponent markupComponent) {
        return markupComponent instanceof End && "style".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordParagraphPropertiesDefaultStart(MarkupComponent markupComponent) {
        return markupComponent instanceof ParagraphStart && "pPrDefault".equals(((ParagraphStart)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordRunPropertiesDefaultStart(MarkupComponent markupComponent) {
        return markupComponent instanceof Start && "rPrDefault".equals(((Start)markupComponent).getName().getLocalPart());
    }

    public static boolean isWordRunPropertiesDefaultEnd(MarkupComponent markupComponent) {
        return markupComponent instanceof End && "rPrDefault".equals(((End)markupComponent).getName().getLocalPart());
    }

    public static boolean isParagraphBlockProperties(MarkupComponent markupComponent) {
        return markupComponent instanceof ParagraphBlockProperties;
    }

    public static boolean isRunProperties(MarkupComponent markupComponent) {
        return markupComponent instanceof RunProperties;
    }

    public static boolean isTableBlockProperties(MarkupComponent markupComponent) {
        return markupComponent instanceof BlockProperties && "tblPr".equals(((BlockProperties)markupComponent).startElement().getName().getLocalPart());
    }

    public static final class General
    implements MarkupComponent {
        private static final Set<Character> WHITESPACES = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
        private List<XMLEvent> events;

        General(List<XMLEvent> events) {
            this.events = events;
        }

        boolean eventsAreWhitespaces() {
            if (this.events.stream().allMatch(e -> 5 == e.getEventType() || 3 == e.getEventType() || e.isCharacters())) {
                return this.events.stream().filter(e -> e.isCharacters()).map(e -> e.asCharacters().getData()).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).allMatch(c -> WHITESPACES.contains(c));
            }
            return false;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.events;
        }
    }

    public static class EmptyElement
    implements MarkupComponent,
    Nameable {
        private static final int EMPTY_ELEMENT_EVENTS_SIZE = 2;
        private XMLEventFactory eventFactory;
        private StartElement startElement;
        private EndElement endElement;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        EmptyElement(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.endElement = endElement;
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                this.attributes.add(iterator.next());
            }
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
            events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
            events.add(this.endElement);
            return events;
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        List<Attribute> getAttributes() {
            return this.attributes;
        }
    }

    public static class End
    implements MarkupComponent,
    Nameable {
        private EndElement endElement;

        End(EndElement endElement) {
            this.endElement = endElement;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.singletonList(this.endElement);
        }

        @Override
        public QName getName() {
            return this.endElement.getName();
        }

        public String toString() {
            return "</".concat(this.endElement.getName().getPrefix()).concat(":").concat(this.endElement.getName().getLocalPart()).concat(">");
        }
    }

    public static final class ParagraphStart
    implements MarkupComponent,
    Nameable {
        private final Start start;
        private final StyleDefinitions styleDefinitions;

        ParagraphStart(XMLEventFactory eventFactory, StyleDefinitions styleDefinitions, StartElement startElement) {
            this(new Start(eventFactory, startElement), styleDefinitions);
        }

        ParagraphStart(Start start, StyleDefinitions styleDefinitions) {
            this.start = start;
            this.styleDefinitions = styleDefinitions;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.start.getEvents();
        }

        @Override
        public QName getName() {
            return this.start.getName();
        }

        List<Attribute> getAttributes() {
            return this.start.getAttributes();
        }

        boolean containsAttributeWithAnyOfValues(String name, Set<String> values) {
            return this.start.containsAttributeWithAnyOfValues(name, values);
        }

        StyleDefinitions styleDefinitions() {
            return this.styleDefinitions;
        }

        public String toString() {
            return this.start.toString();
        }
    }

    public static class Start
    implements MarkupComponent,
    Nameable {
        private XMLEventFactory eventFactory;
        private StartElement startElement;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        Start(XMLEventFactory eventFactory, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                this.attributes.add(iterator.next());
            }
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.singletonList(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        List<Attribute> getAttributes() {
            return this.attributes;
        }

        boolean containsAttributeWithAnyOfValues(String name, Set<String> values) {
            return this.attributes.stream().anyMatch(a -> a.getName().getLocalPart().equals(name) && values.contains(a.getValue()));
        }

        public String toString() {
            return "<".concat(this.startElement.getName().getPrefix()).concat(":").concat(this.startElement.getName().getLocalPart()).concat(">");
        }
    }
}

