/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.List;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.StoryChildElement;

class DocumentPartEventBuilder
implements Builder<Event> {
    private final IdGenerator documentPartIdGenerator;
    private final Markup markup;

    DocumentPartEventBuilder(IdGenerator documentPartIdGenerator, Markup markup) {
        this.documentPartIdGenerator = documentPartIdGenerator;
        this.markup = markup;
    }

    void addMarkupRange(List<XMLEvent> events) {
        this.markup.add(new MarkupRange.Default(events));
    }

    void addMarkupRangeStartElement(StartElement startElement) {
        this.markup.add(new MarkupRange.Start(startElement));
    }

    void addMarkupRangeEndElement(EndElement endElement) {
        this.markup.add(new MarkupRange.End(endElement));
    }

    void addMarkupRangeElement(StoryChildElement storyChildElement) {
        this.markup.add(storyChildElement);
    }

    @Override
    public Event build() {
        DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
        documentPart.setSkeleton(new MarkupSkeleton(this.markup));
        return new Event(EventType.DOCUMENT_PART, documentPart);
    }
}

