/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.WhitespaceStrategy;

public class TextPart
implements IResource {
    public String id;
    public String originalId;
    public TextFragment text;
    public WhitespaceStrategy whitespaceStrategy;
    protected Map<String, Property> properties = new HashMap<String, Property>();
    protected Annotations annotations = new Annotations();

    public TextPart() {
        this.text = new TextFragment();
        this.whitespaceStrategy = WhitespaceStrategy.INHERIT;
    }

    public TextPart(TextFragment text) {
        this();
        this.text = text;
    }

    public TextPart(String id, TextFragment text) {
        this();
        this.id = id;
        this.text = text == null ? new TextFragment() : text;
    }

    public TextPart(String text) {
        this();
        this.text = new TextFragment(text);
    }

    public TextPart clone() {
        TextPart tp = new TextPart(this.id, this.text.clone());
        tp.originalId = this.originalId;
        tp.whitespaceStrategy = this.whitespaceStrategy;
        IWithProperties.copy(this, tp);
        IWithAnnotations.copy(this, tp);
        return tp;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        if (this.text == null) {
            return "";
        }
        return this.text.toText();
    }

    public TextFragment getContent() {
        return this.text;
    }

    public void setContent(TextFragment fragment) {
        this.text = fragment;
    }

    public WhitespaceStrategy getWhitespaceStrategy() {
        return this.whitespaceStrategy;
    }

    public void setWhitespaceStrategy(WhitespaceStrategy whitespaceStrategy) {
        this.whitespaceStrategy = whitespaceStrategy;
    }

    public boolean isSegment() {
        return false;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public Annotations getAnnotations() {
        return this.annotations;
    }

    public boolean preserveWhitespaces() {
        return this.whitespaceStrategy == WhitespaceStrategy.PRESERVE;
    }

    public void setPreserveWhitespaces(boolean preserveWS) {
        if (preserveWS) {
            this.whitespaceStrategy = WhitespaceStrategy.PRESERVE;
            return;
        }
        this.whitespaceStrategy = WhitespaceStrategy.NORMALIZE;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }
}

