/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlInputStreamReader
extends InputStreamReader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_UNICODE_CHAR = 0x10FFFF;
    private static final int REPLACEMENT_CHARACTER = 65533;
    private char[] cbuf = new char[1024];
    private int nextChar = 0;
    private int max = 0;

    public XmlInputStreamReader(InputStream in) {
        super(in);
    }

    public XmlInputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        super(in, charsetName);
    }

    public XmlInputStreamReader(InputStream in, Charset cs) {
        super(in, cs);
    }

    public XmlInputStreamReader(InputStream in, CharsetDecoder dec) {
        super(in, dec);
    }

    private int fillBuffer() throws IOException {
        int remaining = this.max - this.nextChar;
        System.arraycopy(this.cbuf, this.nextChar, this.cbuf, 0, remaining);
        int i = super.read(this.cbuf, remaining, this.cbuf.length - remaining);
        this.max = remaining + Math.max(0, i);
        this.nextChar = 0;
        return i;
    }

    private int _read() throws IOException {
        int i;
        if (this.nextChar >= this.max && (i = this.fillBuffer()) == -1) {
            return -1;
        }
        return this.cbuf[this.nextChar++];
    }

    private int ensureAvailableChars(int count) throws IOException {
        if (this.nextChar + count > this.max) {
            this.fillBuffer();
        }
        return this.max - this.nextChar;
    }

    @Override
    public int read() throws IOException {
        int c = this._read();
        if (c == -1) {
            return c;
        }
        if (c == 38) {
            int available = this.ensureAvailableChars(8);
            if (available == -1) {
                return 38;
            }
            Entity entity = XmlInputStreamReader.resolveEntity(this.cbuf, this.nextChar, this.max);
            if (entity == null || !entity.invalid) {
                return 38;
            }
            this.logger.error(String.format("Invalid XML character U+%04X from entity &%s", entity.value, new String(this.cbuf, this.nextChar, entity.size)));
            this.nextChar += entity.size;
            return 65533;
        }
        if (Character.isSurrogate((char)c)) {
            return c;
        }
        if (XmlInputStreamReader.validateChar(c)) {
            return c;
        }
        this.logger.error(String.format("Invalid XML character U+%04X", c));
        return 65533;
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int i;
        for (i = 0; i < length; ++i) {
            int c = this.read();
            if (c == -1) {
                return i == 0 ? -1 : i;
            }
            cbuf[offset + i] = (char)c;
        }
        return i;
    }

    private static boolean validateChar(int value) {
        if (value >= 55296) {
            if (value < 57344) {
                return false;
            }
            if (value > 65535 ? value > 0x10FFFF : value >= 65534) {
                return false;
            }
        } else if (value < 32) {
            if (value == 0) {
                return false;
            }
            if (value != 9 && value != 10 && value != 13) {
                return false;
            }
        }
        return true;
    }

    public static Entity resolveEntity(char[] buf, int ptr, int size) {
        int initialPtr = ptr;
        if (ptr >= size - 2) {
            return null;
        }
        char c = buf[ptr++];
        boolean invalid = false;
        if (c == '#') {
            c = buf[ptr++];
            int value = 0;
            if (c == 'x') {
                while (c != ';' && ptr < size) {
                    if ((c = buf[ptr++]) == ';') {
                        return new Entity(value, ptr - initialPtr, invalid);
                    }
                    if (invalid) continue;
                    int hexVal = Character.digit(c, 16);
                    if (hexVal == -1) {
                        return null;
                    }
                    invalid = (value = (value << 4) + hexVal) > 0x10FFFF;
                }
            } else {
                while (c != ';') {
                    if (!invalid) {
                        int decVal = Character.digit(c, 10);
                        if (decVal == -1) {
                            return null;
                        }
                        boolean bl = invalid = (value = value * 10 + decVal) > 0x10FFFF;
                    }
                    if (ptr >= size) break;
                    c = buf[ptr++];
                }
                ++ptr;
            }
            if (c == ';') {
                return new Entity(value, ptr - initialPtr - 1, invalid);
            }
        } else if (c == 'a') {
            if ((c = buf[ptr++]) == 'm') {
                if (buf[ptr++] == 'p' && buf[ptr++] == ';') {
                    return new Entity(38, ptr - initialPtr, invalid);
                }
            } else if (c == 'p' && buf[ptr++] == 'o' && buf[ptr++] == 's' && buf[ptr++] == ';') {
                return new Entity(39, ptr - initialPtr, invalid);
            }
        } else if (c == 'g') {
            if (buf[ptr++] == 't' && buf[ptr++] == ';') {
                return new Entity(62, ptr - initialPtr, invalid);
            }
        } else if (c == 'l') {
            if (buf[ptr++] == 't' && buf[ptr++] == ';') {
                return new Entity(60, ptr - initialPtr, invalid);
            }
        } else if (c == 'q' && buf[ptr++] == 'u' && buf[ptr++] == 'o' && buf[ptr++] == 't' && buf[ptr++] == ';') {
            return new Entity(34, ptr - initialPtr, invalid);
        }
        return null;
    }

    static class Entity {
        int value;
        int size;
        boolean invalid;

        Entity(int value, int size, boolean invalid) {
            this.value = value;
            this.size = size;
            this.invalid = invalid ? true : !XmlInputStreamReader.validateChar(value);
        }
    }
}

