/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class DefaultFilenameFilter
implements FilenameFilter {
    private Pattern pattern;

    public DefaultFilenameFilter(String pattern, boolean caseSensitive) {
        if (pattern == null) {
            throw new NullPointerException("Mask of the filename cannot be null.");
        }
        pattern = pattern.replace('.', '\b');
        pattern = pattern.replace("*", ".*");
        pattern = pattern.replace('?', '.');
        pattern = pattern.replace("\b", "\\.");
        this.pattern = caseSensitive ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
    }

    public DefaultFilenameFilter(String extension) {
        this("*" + extension, false);
    }

    @Override
    public boolean accept(File directory, String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.pattern.matcher(fileName).matches();
    }
}

