/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.lib.extra.AbstractParameters;

@EditorFor(value=Parameters.class)
public class Parameters
extends AbstractParameters
implements IEditorDescriptionProvider {
    private static final String COUNTINTEXTUNITS = "countInTextUnits";
    private static final String COUNTINBATCH = "countInBatch";
    private static final String COUNTINBATCHITEMS = "countInBatchItems";
    private static final String COUNTINDOCUMENTS = "countInDocuments";
    private static final String COUNTINSUBDOCUMENTS = "countInSubDocuments";
    private static final String COUNTINGROUPS = "countInGroups";
    private static final String BUFFERSIZE = "bufferSize";
    private boolean countInBatch;
    private boolean countInBatchItems;
    private boolean countInDocuments;
    private boolean countInSubDocuments;
    private boolean countInGroups;
    private int bufferSize;

    public boolean getCountInBatch() {
        return this.countInBatch;
    }

    public void setCountInBatch(boolean countInBatch) {
        this.countInBatch = countInBatch;
    }

    public boolean getCountInBatchItems() {
        return this.countInBatchItems;
    }

    public void setCountInBatchItems(boolean countInBatchItems) {
        this.countInBatchItems = countInBatchItems;
    }

    public boolean getCountInDocuments() {
        return this.countInDocuments;
    }

    public void setCountInDocuments(boolean countInDocuments) {
        this.countInDocuments = countInDocuments;
    }

    public boolean getCountInSubDocuments() {
        return this.countInSubDocuments;
    }

    public void setCountInSubDocuments(boolean countInSubDocuments) {
        this.countInSubDocuments = countInSubDocuments;
    }

    public boolean getCountInGroups() {
        return this.countInGroups;
    }

    public void setCountInGroups(boolean countInGroups) {
        this.countInGroups = countInGroups;
    }

    public boolean getCountInTextUnits() {
        return true;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    protected void parameters_init() {
    }

    @Override
    protected void parameters_load(ParametersString buffer) {
        this.countInBatch = buffer.getBoolean(COUNTINBATCH, this.countInBatch);
        this.countInBatchItems = buffer.getBoolean(COUNTINBATCHITEMS, this.countInBatchItems);
        this.countInDocuments = buffer.getBoolean(COUNTINDOCUMENTS, this.countInDocuments);
        this.countInSubDocuments = buffer.getBoolean(COUNTINSUBDOCUMENTS, this.countInSubDocuments);
        this.countInGroups = buffer.getBoolean(COUNTINGROUPS, this.countInGroups);
        this.bufferSize = buffer.getInteger(BUFFERSIZE, this.bufferSize);
    }

    @Override
    protected void parameters_reset() {
        this.countInBatch = true;
        this.countInBatchItems = true;
        this.countInDocuments = false;
        this.countInSubDocuments = false;
        this.countInGroups = false;
        this.bufferSize = 0;
    }

    @Override
    protected void parameters_save(ParametersString buffer) {
        buffer.setBoolean(COUNTINBATCH, this.countInBatch);
        buffer.setBoolean(COUNTINBATCHITEMS, this.countInBatchItems);
        buffer.setBoolean(COUNTINDOCUMENTS, this.countInDocuments);
        buffer.setBoolean(COUNTINSUBDOCUMENTS, this.countInSubDocuments);
        buffer.setBoolean(COUNTINGROUPS, this.countInGroups);
        buffer.setInteger(BUFFERSIZE, this.bufferSize);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(COUNTINTEXTUNITS, "Text units", null);
        desc.add(COUNTINBATCH, "Batches", null);
        desc.add(COUNTINBATCHITEMS, "Batch items", null);
        desc.add(COUNTINDOCUMENTS, "Documents", null);
        desc.add(COUNTINSUBDOCUMENTS, "Sub-documents", null);
        desc.add(COUNTINGROUPS, "Groups", null);
        desc.add(BUFFERSIZE, "Size of text buffer:", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Word or Character Count", true, false);
        desc.addTextLabelPart("Create a word or character count annotation for each of the following resources:");
        desc.addCheckboxPart(paramsDesc.get(COUNTINTEXTUNITS));
        desc.addCheckboxPart(paramsDesc.get(COUNTINBATCH));
        desc.addCheckboxPart(paramsDesc.get(COUNTINBATCHITEMS));
        desc.addCheckboxPart(paramsDesc.get(COUNTINDOCUMENTS));
        desc.addCheckboxPart(paramsDesc.get(COUNTINSUBDOCUMENTS));
        desc.addCheckboxPart(paramsDesc.get(COUNTINGROUPS));
        desc.addSpinInputPart(paramsDesc.get(BUFFERSIZE));
        return desc;
    }
}

