/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.inconsistencycheck;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.steps.inconsistencycheck.InconsistencyCheck;
import net.sf.okapi.steps.inconsistencycheck.Parameters;

@UsingParameters(value=Parameters.class)
public class InconsistencyCheckStep
extends BasePipelineStep {
    private InconsistencyCheck checker = new InconsistencyCheck();
    private int docIdValue;
    private String docId;
    private String tuId;
    private String segId;
    private int subDocIdValue;
    private String subDocId;
    private String rootDir;
    private String finalPath;
    private String inputRootDir;
    private LocaleId targetLocale;

    @Override
    public String getName() {
        return "Inconsistency Check";
    }

    @Override
    public String getDescription() {
        return "Checks for source entries that are the same but have different translations or target entries that are the same but have different sources. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public Parameters getParameters() {
        return this.checker.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.checker.setParameters((Parameters)params);
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public Event handleStartBatch(Event event) {
        this.docIdValue = 0;
        this.finalPath = Util.fillRootDirectoryVariable(this.checker.getParameters().getOutputPath(), this.rootDir);
        this.finalPath = Util.fillInputRootDirectoryVariable(this.finalPath, this.inputRootDir);
        return event;
    }

    @Override
    public Event handleStartDocument(Event event) {
        ++this.docIdValue;
        String docName = event.getStartDocument().getName();
        this.docId = docName == null ? Integer.toString(this.docIdValue) : docName;
        this.subDocIdValue = 0;
        return event;
    }

    @Override
    public Event handleStartSubDocument(Event event) {
        ++this.subDocIdValue;
        this.subDocId = Integer.toString(this.subDocIdValue);
        return event;
    }

    @Override
    public Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        this.tuId = tu.getId();
        ISegments srcSegs = tu.getSourceSegments();
        if (!tu.hasTarget(this.targetLocale)) {
            return event;
        }
        ISegments trgSegs = tu.getTargetSegments(this.targetLocale);
        for (Segment srcSeg : srcSegs) {
            this.segId = srcSeg.getId();
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (trgSeg == null) continue;
            this.checker.store(this.docId, this.subDocId, this.tuId, this.segId, srcSeg.getContent(), trgSeg.getContent());
        }
        return event;
    }

    @Override
    public Event handleEndDocument(Event event) {
        if (this.checker.getParameters().getCheckPerFile()) {
            this.checker.generateReport(this.finalPath, false);
        }
        return event;
    }

    @Override
    public Event handleEndBatch(Event event) {
        this.checker.generateReport(this.finalPath, true);
        return event;
    }
}

