/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.codesremoval;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.steps.codesremoval.CodesRemover;
import net.sf.okapi.steps.codesremoval.Parameters;

@UsingParameters(value=Parameters.class)
public class CodesRemovalStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private LocaleId targetLocale;
    private CodesRemover remover;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public String getName() {
        return "Inline Codes Removal";
    }

    @Override
    public String getDescription() {
        return "Removes inline codes from the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        if (this.remover == null) {
            this.remover = new CodesRemover(this.params, this.targetLocale);
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.remover.processTextUnit(event.getTextUnit());
        return event;
    }
}

