/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.document;

import java.util.Iterator;
import java.util.Stack;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.document.EventIterator;
import net.sf.okapi.lib.xliff2.document.GroupNode;
import net.sf.okapi.lib.xliff2.document.IGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.IWithGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.WithGroupOrUnitNode;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.URIContext;

public class FileNode
extends WithGroupOrUnitNode
implements IWithGroupOrUnitNode {
    private StartFileData startData;
    private Skeleton skelData;
    private MidFileData midData;

    public FileNode(StartFileData data) {
        this.startData = data;
    }

    public StartFileData getStartData() {
        return this.startData;
    }

    public void setMidData(MidFileData data) {
        this.midData = data;
    }

    public MidFileData getMidData() {
        return this.midData;
    }

    public void setSkeletonData(Skeleton data) {
        this.skelData = data;
    }

    public Skeleton getSkeletonData() {
        return this.skelData;
    }

    public Iterator<Event> createEventIterator(Stack<URIContext> uriContext) {
        EventIterator ei = new EventIterator(){
            private Iterator<IGroupOrUnitNode> iter;
            private Iterator<Event> eventIter;
            private int state;
            {
                this.iter = FileNode.this.createGroupOrUnitIterator();
                this.eventIter = null;
                this.state = 0;
            }

            @Override
            public boolean hasNext() {
                switch (this.state) {
                    case 0: {
                        return true;
                    }
                    case -1: {
                        return false;
                    }
                    case 1: {
                        if (FileNode.this.skelData != null) {
                            return true;
                        }
                        this.state = 2;
                    }
                    case 2: {
                        if (FileNode.this.midData != null) {
                            return true;
                        }
                        this.state = 3;
                    }
                }
                if (this.eventIter != null) {
                    if (this.eventIter.hasNext()) {
                        return true;
                    }
                    this.eventIter = null;
                }
                if (this.iter.hasNext()) {
                    return true;
                }
                this.state = 4;
                return true;
            }

            @Override
            public Event next() {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                        ((URIContext)this.uriContext.peek()).setFileId(FileNode.this.startData.getId());
                        return new Event(EventType.START_FILE, (URIContext)this.uriContext.peek(), FileNode.this.startData);
                    }
                    case 1: {
                        this.state = 2;
                        return new Event(EventType.SKELETON, (URIContext)this.uriContext.peek(), FileNode.this.skelData);
                    }
                    case 2: {
                        this.state = 3;
                        return new Event(EventType.MID_FILE, (URIContext)this.uriContext.peek(), FileNode.this.midData);
                    }
                    case 4: {
                        this.state = -1;
                        this.uriContext.pop();
                        return new Event(EventType.END_FILE, null);
                    }
                }
                if (this.eventIter != null) {
                    return this.eventIter.next();
                }
                IGroupOrUnitNode node = this.iter.next();
                if (node.isUnit()) {
                    this.uriContext.push(((URIContext)this.uriContext.peek()).clone());
                    ((URIContext)this.uriContext.peek()).setUnitId(((UnitNode)node).get().getId());
                    Event event = new Event(EventType.TEXT_UNIT, (URIContext)this.uriContext.peek(), ((UnitNode)node).get());
                    this.uriContext.pop();
                    return event;
                }
                this.eventIter = ((GroupNode)node).createEventIterator(this.uriContext);
                this.eventIter.hasNext();
                return this.eventIter.next();
            }
        };
        ei.setURIContext(uriContext);
        return ei;
    }
}

