/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.xliff2.util.PropertiesMapper;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.metadata.IMetadataItem;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X2ToOkpConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LocaleId trgLoc;

    public X2ToOkpConverter(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public DocumentPart convert(MidFileData midFileData) {
        DocumentPart documentPart = new DocumentPart();
        if (midFileData.hasMetadata()) {
            GenericAnnotation contextGroup = this.metadataToContextGroup(midFileData.getMetadata());
            documentPart.setAnnotation(new GenericAnnotations(contextGroup));
        }
        return documentPart;
    }

    public StartGroup convert(StartGroupData sgd, String parentId) {
        StartGroup sg = new StartGroup(parentId, sgd.getId());
        if (sgd.hasMetadata()) {
            GenericAnnotation contextGroup = this.metadataToContextGroup(sgd.getMetadata());
            sg.setAnnotation(new GenericAnnotations(contextGroup));
        }
        return sg;
    }

    private GenericAnnotation metadataToContextGroup(Metadata md) {
        GenericAnnotation contextGroup = new GenericAnnotation("misc-metadata");
        int i = 0;
        for (MetaGroup metaGroup : md) {
            this.addMeta(metaGroup, contextGroup, String.valueOf(i));
            ++i;
        }
        return contextGroup;
    }

    private void addMeta(IMetadataItem fromMetadata, GenericAnnotation toContextGroup, String sequenceId) {
        if (fromMetadata.isGroup()) {
            MetaGroup metaGroup = (MetaGroup)fromMetadata;
            Iterator metaIterator = metaGroup.iterator();
            int i = 0;
            while (metaIterator.hasNext()) {
                IMetadataItem next = (IMetadataItem)metaIterator.next();
                this.addMeta(next, toContextGroup, sequenceId + "." + String.valueOf(i));
                ++i;
            }
        } else {
            Meta meta = (Meta)fromMetadata;
            if (toContextGroup.getString(meta.getType()) != null) {
                toContextGroup.setString(meta.getType() + "." + sequenceId, meta.getData());
            } else {
                toContextGroup.setString(meta.getType(), meta.getData());
            }
        }
    }

    public ITextUnit convert(Unit unit) {
        TextUnit tu = new TextUnit(unit.getId());
        tu.setName(unit.getName());
        tu.setType(unit.getType());
        TextContainer tc = tu.getSource();
        this.convert(unit, tc, false);
        boolean hasTarget = false;
        for (Part part : unit) {
            if (!part.hasTarget()) continue;
            hasTarget = true;
            break;
        }
        if (hasTarget) {
            tc = tu.createTarget(this.trgLoc, false, 0);
            this.convert(unit, tc, true);
        }
        if (unit.hasMetadata()) {
            GenericAnnotation contextGroup = this.metadataToContextGroup(unit.getMetadata());
            tu.setAnnotation(new GenericAnnotations(contextGroup));
        }
        return tu;
    }

    private void convert(Unit unit, TextContainer dest, boolean isTarget) {
        ArrayList<Segment> textParts = new ArrayList<Segment>();
        int segId = 1;
        int tpId = 1;
        for (Part part : unit) {
            TextPart converted;
            String id = part.getId();
            if (part.isSegment()) {
                converted = this.convertToSegment(part, Util.isEmpty(id) ? String.valueOf(segId) : id);
                ++segId;
            } else {
                converted = this.convertToTextPart(part, Util.isEmpty(id) ? String.valueOf(tpId) : id);
                ++tpId;
            }
            if (isTarget) {
                if (part.hasTarget()) {
                    this.convert(part.getTarget(), converted);
                }
            } else {
                this.convert(part.getSource(), converted);
            }
            textParts.add((Segment)converted);
            PropertiesMapper.setPartProperties(part, converted);
        }
        dest.setParts(textParts.toArray(new TextPart[0]));
    }

    private Segment convertToSegment(Part part, String id) {
        Segment s = new Segment(id);
        s.originalId = part.getId();
        return s;
    }

    private TextPart convertToTextPart(Part part, String id) {
        TextPart tp = new TextPart(id, null);
        tp.originalId = part.getId();
        return tp;
    }

    private void convert(Fragment frag, TextPart part) {
        TextFragment tf = part.text;
        for (Object obj : frag) {
            if (obj instanceof String) {
                tf.append((String)obj);
                continue;
            }
            if (obj instanceof CTag) {
                CTag ctag = (CTag)obj;
                Code code = new Code(ctag.getType());
                PropertiesMapper.setCodeProperties(ctag, code);
                tf.append(code);
                continue;
            }
            if (!(obj instanceof MTag)) continue;
            this.logger.warn("Xliff 2 marker tags (mrk) are not supported segment/ignorable id='{}' mtag id='{}'", (Object)part.originalId, (Object)((MTag)obj).getId());
            tf.append("[MARKER]");
        }
    }
}

