/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.Text;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

class Run
implements Chunk {
    private static final String START_MARKUP_COMPONENT_IS_NOT_FOUND = "Unexpected structure: the start markup component is not found";
    private StartElement startEvent;
    private EndElement endEvent;
    private RunProperties runProperties;
    private RunProperties combinedProperties;
    private List<Chunk> bodyChunks;
    private List<Textual> nestedTextualItems;
    private boolean isHidden;

    Run(StartElement startEvent, EndElement endEvent, RunProperties runProperties, RunProperties combinedProperties, List<Chunk> bodyChunks, List<Textual> nestedTextualItems, boolean isHidden) {
        this.startEvent = startEvent;
        this.endEvent = endEvent;
        this.runProperties = runProperties;
        this.combinedProperties = combinedProperties;
        this.bodyChunks = bodyChunks;
        this.nestedTextualItems = nestedTextualItems;
        this.isHidden = isHidden;
    }

    RunProperties getProperties() {
        return this.runProperties;
    }

    void refineRunProperties(List<RunProperty> runProperties) {
        for (RunProperty runProperty : runProperties) {
            this.runProperties.remove(runProperty);
        }
        if (0 == this.runProperties.count()) {
            this.runProperties = RunProperties.emptyRunProperties();
        }
    }

    RunProperties getCombinedProperties() {
        return this.combinedProperties;
    }

    List<Chunk> getBodyChunks() {
        return this.bodyChunks;
    }

    List<Textual> getNestedTextualItems() {
        return this.nestedTextualItems;
    }

    boolean containsVisibleText() {
        if (this.isHidden) {
            return false;
        }
        for (Chunk c : this.bodyChunks) {
            if (!(c instanceof RunText)) continue;
            return true;
        }
        return false;
    }

    boolean containsParagraphBlockProperties() {
        if (this.bodyChunks.get(0) instanceof Markup) {
            return ((Markup)this.bodyChunks.get(0)).components().stream().anyMatch(mc -> mc instanceof ParagraphBlockProperties);
        }
        return false;
    }

    void refineParagraphBlockProperties(ParagraphBlockProperties paragraphBlockProperties) {
        ListIterator<MarkupComponent> componentsIterator = ((Markup)this.bodyChunks.get(0)).components().listIterator();
        while (componentsIterator.hasNext()) {
            MarkupComponent markupComponent = componentsIterator.next();
            if (!(markupComponent instanceof ParagraphBlockProperties)) continue;
            if (null == paragraphBlockProperties) {
                componentsIterator.remove();
            } else {
                componentsIterator.set(paragraphBlockProperties);
            }
            return;
        }
        Run.rewindAfterStartMarkupComponent(componentsIterator);
        componentsIterator.add(paragraphBlockProperties);
    }

    private static void rewindAfterStartMarkupComponent(ListIterator<MarkupComponent> iterator) {
        while (iterator.hasPrevious()) {
            if (!(iterator.previous() instanceof MarkupComponent.Start)) continue;
            iterator.next();
            return;
        }
        throw new IllegalStateException(START_MARKUP_COMPONENT_IS_NOT_FOUND);
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startEvent);
        events.addAll(this.runProperties.getEvents());
        for (XMLEvents xMLEvents : this.bodyChunks) {
            events.addAll(xMLEvents.getEvents());
        }
        events.add(this.endEvent);
        return events;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + XMLEventSerializer.serialize(this.getEvents()) + "]";
    }

    static class Markup
    implements net.sf.okapi.filters.openxml.Markup,
    RunChunk {
        private final Markup.General generalMarkup;

        Markup(Markup.General generalMarkup) {
            this.generalMarkup = generalMarkup;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.generalMarkup.getEvents();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.generalMarkup.apply(fontMappings);
        }

        @Override
        public void addComponent(MarkupComponent component) {
            this.generalMarkup.addComponent(component);
        }

        @Override
        public void addComponents(List<MarkupComponent> components) {
            this.generalMarkup.addComponents(components);
        }

        @Override
        public void addMarkup(net.sf.okapi.filters.openxml.Markup markup) {
            this.generalMarkup.addMarkup(markup);
        }

        @Override
        public List<MarkupComponent> components() {
            return this.generalMarkup.components();
        }

        @Override
        public Nameable nameableComponent() {
            return this.generalMarkup.nameableComponent();
        }
    }

    static interface RunChunk
    extends Chunk {
    }

    static class RunText
    extends Text
    implements RunChunk {
        RunText(StartElement startElement, Characters text, EndElement endElement) {
            super(startElement, text, endElement);
        }
    }
}

