/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.TranslatablePart;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class ExcelFormulaPart
extends TranslatablePart {
    private static final String NAME = "name";
    private static Pattern FORMULA_PATTERN = Pattern.compile("(.*?[\\[\"]{1})([a-zA-Z0-9 \\*]+?)([\\]\"]{1}.*)", 32);
    private final Map<String, String> sharedStrings;
    private final InputStream inputStream;
    private String subDocumentId;
    private Iterator<Event> filterEventIterator;

    ExcelFormulaPart(Document.General generalDocument, ZipEntry entry, Map<String, String> sharedStrings, InputStream inputStream) {
        super(generalDocument, entry);
        this.inputStream = inputStream;
        this.sharedStrings = sharedStrings;
    }

    String getModifiedContent() throws XMLStreamException, IOException {
        StringWriter sw = new StringWriter();
        XMLEventWriter xmlEventWriter = this.generalDocument.outputFactory().createXMLEventWriter(sw);
        XMLEventReader xmlReader = this.createXMLReader();
        while (xmlReader.hasNext()) {
            XMLEvent e = xmlReader.nextEvent();
            if (XMLEventHelpers.isTableColumnEvent(e)) {
                e = this.rewriteNameAttribute(e);
            } else if (XMLEventHelpers.isExcelFormula(e)) {
                xmlEventWriter.add(e);
                e = xmlReader.nextEvent();
                if (e.isCharacters()) {
                    e = this.generalDocument.eventFactory().createCharacters(this.updateTextualReferencesInParsedCharacterData(e.asCharacters()));
                }
            }
            xmlEventWriter.add(e);
        }
        return sw.toString();
    }

    private XMLEventReader createXMLReader() throws XMLStreamException, IOException {
        return this.generalDocument.inputFactory().createXMLEventReader(new InputStreamReader(new BufferedInputStream(this.inputStream)));
    }

    private XMLEvent rewriteNameAttribute(XMLEvent e) {
        String value = e.asStartElement().getAttributeByName(new QName(NAME)).getValue();
        String translatedSharedString = this.sharedStrings.get(value);
        if (translatedSharedString == null) {
            return e;
        }
        Attribute attr = this.generalDocument.eventFactory().createAttribute(NAME, translatedSharedString);
        Iterator<Attribute> attributeIterator = e.asStartElement().getAttributes();
        ArrayList<Attribute> updatedAttributes = new ArrayList<Attribute>();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            if (NAME.equalsIgnoreCase(attribute.getName().toString())) {
                updatedAttributes.add(attr);
                continue;
            }
            updatedAttributes.add(attribute);
        }
        return this.generalDocument.eventFactory().createStartElement(e.asStartElement().getName(), updatedAttributes.iterator(), e.asStartElement().getNamespaces());
    }

    private String updateTextualReferencesInParsedCharacterData(Characters pcdata) {
        StringBuilder result = new StringBuilder();
        String text = pcdata.getData();
        Matcher formulaMatcher = FORMULA_PATTERN.matcher(text);
        String formulaPart = null;
        if (!formulaMatcher.find()) {
            return text;
        }
        while (formulaMatcher.groupCount() == FORMULA_MATCHER_GROUPS.values().length) {
            result.append(formulaMatcher.group(FORMULA_MATCHER_GROUPS.NON_TRANSLATABLE.getValue()));
            String textUnitPart = formulaMatcher.group(FORMULA_MATCHER_GROUPS.TRANSLATABLE.getValue());
            if (this.sharedStrings.get(textUnitPart) == null) {
                result.append(textUnitPart);
            } else {
                result.append(this.sharedStrings.get(textUnitPart));
            }
            formulaPart = formulaMatcher.group(FORMULA_MATCHER_GROUPS.UNPROCESSED.getValue());
            formulaMatcher.reset(formulaPart);
            if (formulaMatcher.find()) continue;
        }
        if (formulaPart != null) {
            result.append(formulaPart);
        }
        return result.toString();
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.process();
        return this.createStartSubDocumentEvent(this.generalDocument.documentId(), this.subDocumentId);
    }

    private void process() throws XMLStreamException, IOException {
        DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
        documentPart.setSkeleton(new GenericSkeleton(this.getModifiedContent()));
        this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    @Override
    public boolean hasNextEvent() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }

    private static enum FORMULA_MATCHER_GROUPS {
        NON_TRANSLATABLE(1),
        TRANSLATABLE(2),
        UNPROCESSED(3);

        private final int value;

        private FORMULA_MATCHER_GROUPS(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

