/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.XLIFFNote;
import net.sf.okapi.common.annotation.XLIFFNoteAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.JSONEncoder;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.json.JsonEventBuilder;
import net.sf.okapi.filters.json.Parameters;
import net.sf.okapi.filters.json.parser.IJsonHandler;
import net.sf.okapi.filters.json.parser.JsonKeyTypes;
import net.sf.okapi.filters.json.parser.JsonParser;
import net.sf.okapi.filters.json.parser.JsonValueTypes;
import net.sf.okapi.filters.json.parser.ParseException;
import net.sf.okapi.filters.json.parser.StreamProvider;
import net.sf.okapi.filters.json.parser.TokenMgrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class JSONFilter
extends AbstractFilter
implements IJsonHandler {
    private static final String MIMETYPE = "application/json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private Parameters params;
    private JsonEventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private IFilter subFilter;
    private Stack<KeyAndType> keyNames;
    private String currentKeyName;
    private JsonKeyTypes currentKeyType;
    private Pattern exceptions;
    private int subfilterIndex;
    private RawDocument input;
    private XLIFFNoteAnnotation notes = null;
    private Pattern noteRulesPat = null;
    private Pattern idRulesPat = null;
    private Pattern extractionRulesPat = null;
    private Pattern genericMetaRulesPat = null;
    private String currentId;
    private List<MetaData> currentGenericMeta;
    private List<ITextUnit> currentTus = new LinkedList<ITextUnit>();

    public JSONFilter() {
        this.setMimeType(MIMETYPE);
        this.setMultilingual(false);
        this.setName("okf_json");
        this.setDisplayName("Json Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "JSON (JavaScript Object Notation)", "Configuration for JSON files", null, ".json;"));
        this.setParameters(new Parameters());
        this.currentGenericMeta = new LinkedList<MetaData>();
    }

    @Override
    public void close() {
        super.close();
        this.hasUtf8Bom = false;
        this.hasUtf8Encoding = false;
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        return this.eventBuilder.next();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        String subFilterName;
        this.input = input;
        super.open(input, generateSkeleton);
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        String encoding = detector.getEncoding();
        String linebreak = detector.getNewlineType().toString();
        this.hasUtf8Bom = detector.hasUtf8Bom();
        this.hasUtf8Encoding = detector.hasUtf8Encoding();
        input.setEncoding(encoding);
        this.setEncoding(encoding);
        this.setNewlineType(linebreak);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), encoding, generateSkeleton);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", encoding), e);
        }
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.exceptions = Util.isEmpty(this.params.getExceptions()) ? null : Pattern.compile(this.params.getExceptions());
        String noteRules = this.params.getNoteRules();
        this.noteRulesPat = !noteRules.isEmpty() ? Pattern.compile(noteRules) : null;
        String idRules = this.params.getIdRules();
        this.idRulesPat = !idRules.isEmpty() ? Pattern.compile(idRules) : null;
        String extractionRules = this.params.getExtractionRules();
        this.extractionRulesPat = !extractionRules.isEmpty() ? Pattern.compile(extractionRules) : null;
        String genericMetaRules = this.params.getGenericMetaRules();
        this.genericMetaRulesPat = !genericMetaRules.isEmpty() ? Pattern.compile(genericMetaRules) : null;
        if (this.eventBuilder == null) {
            this.eventBuilder = new JsonEventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setMimeType(MIMETYPE);
        this.eventBuilder.setPreserveWhitespace(true);
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
            this.eventBuilder.setCodeFinder(this.params.getCodeFinder());
        }
        if (!this.params.getUseCodeFinder() && (subFilterName = this.params.getSubfilter()) != null && !"".equals(subFilterName)) {
            this.subFilter = this.getFilterConfigurationMapper().createFilter(subFilterName, this.subFilter);
        }
        this.subfilterIndex = 0;
        this.keyNames = new Stack();
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
        JsonParser parser = new JsonParser(new StreamProvider(reader));
        parser.setHandler(this);
        try {
            parser.parse();
        }
        catch (ParseException | TokenMgrException e) {
            throw new OkapiBadFilterInputException(String.format("Error parsing JSON file: %s", e.getMessage()), e);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = super.getEncoderManager();
            this.encoderManager.setMapping(MIMETYPE, "net.sf.okapi.common.encoder.JSONEncoder");
        }
        return this.encoderManager;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    public void handleStart() {
        this.setFilterWriter(this.createFilterWriter());
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        if (!Util.isEmpty(this.params.getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(this.params.getSimplifierRules());
            this.eventBuilder.addFilterEvent(cs);
        }
    }

    @Override
    public void handleEnd() {
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    @Override
    public void handleComment(String c) {
        this.eventBuilder.addDocumentPart(c);
    }

    @Override
    public void handleKey(String key, JsonValueTypes valueType, JsonKeyTypes keyType) {
        this.eventBuilder.addDocumentPart(String.format("%s%s%S", valueType.getQuoteChar(), key, valueType.getQuoteChar()));
        this.currentKeyName = key;
        this.currentKeyType = keyType;
    }

    @Override
    public void handleWhitespace(String whitespace) {
        this.eventBuilder.addDocumentPart(whitespace);
    }

    @Override
    public void handleValue(String value, JsonValueTypes valueType) {
        Matcher m;
        String key = this.currentKeyName;
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
        if (!this.params.getExtractStandalone() && key == null) {
            this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
            return;
        }
        switch (valueType) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case SYMBOL: {
                this.eventBuilder.addDocumentPart(value);
                return;
            }
        }
        String fullPathOrKey = this.buildKeyPath(key);
        if (this.idRulesPat != null && (m = this.idRulesPat.matcher(fullPathOrKey)).matches()) {
            this.currentId = value;
            this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
            return;
        }
        if (this.noteRulesPat != null && (m = this.noteRulesPat.matcher(fullPathOrKey)).matches()) {
            XLIFFNote n = new XLIFFNote(value);
            n.setAnnotates(XLIFFNote.Annotates.SOURCE);
            n.setFrom(key);
            if (this.notes == null) {
                this.notes = new XLIFFNoteAnnotation();
            }
            this.notes.add(n);
            this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
            return;
        }
        if (this.genericMetaRulesPat != null && (m = this.genericMetaRulesPat.matcher(fullPathOrKey)).matches()) {
            this.currentGenericMeta.add(new MetaData(fullPathOrKey, value));
            this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
            return;
        }
        if (this.extractionRulesPat != null) {
            m = this.extractionRulesPat.matcher(fullPathOrKey);
            if (!m.matches()) {
                this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
                return;
            }
        } else {
            boolean extract = this.params.getExtractAllPairs();
            if (this.exceptions != null && this.exceptions.matcher(fullPathOrKey).find()) {
                boolean bl = extract = !extract;
            }
            if (!extract) {
                this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
                return;
            }
        }
        if (this.subFilter != null) {
            this.callSubfilter(value, valueType, fullPathOrKey);
            return;
        }
        switch (valueType) {
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: {
                this.eventBuilder.startTextUnit(new GenericSkeleton(valueType.getQuoteChar()));
                this.createTextUnit(value, fullPathOrKey);
                this.eventBuilder.endTextUnit(new GenericSkeleton(valueType.getQuoteChar()));
                break;
            }
            case NUMBER: 
            case SYMBOL: {
                this.eventBuilder.startTextUnit(value);
                this.createTextUnit(value, fullPathOrKey);
                this.eventBuilder.endTextUnit();
                break;
            }
        }
        this.logger.debug("KEYNAME: {} : {}", (Object)fullPathOrKey, (Object)value);
    }

    private void createTextUnit(String value, String key) {
        ITextUnit tu = this.eventBuilder.peekMostRecentTextUnit();
        if (tu != null) {
            tu.getSource().getFirstContent().append(value);
            if (this.params.getUseKeyAsName()) {
                tu.setName(key);
            }
            this.currentTus.add(tu);
        }
    }

    private void callSubfilter(String value, JsonValueTypes valueType, String parentName) {
        String parentId = this.eventBuilder.findMostRecentParentId();
        if (parentId == null) {
            parentId = this.getDocumentId().getLastId();
        }
        JSONEncoder subEncoder = new JSONEncoder();
        subEncoder.setOptions(this.params, this.getEncoding(), this.getNewlineType());
        try (SubFilter sf = new SubFilter(this.subFilter, subEncoder, ++this.subfilterIndex, parentId, parentName);){
            List<Event> events = sf.getEvents(new RawDocument(this.eventBuilder.decode(value), this.getSrcLoc(), this.getTrgLoc()));
            this.eventBuilder.addFilterEvents(events);
            this.eventBuilder.addToDocumentPart(valueType.getQuoteChar());
            this.eventBuilder.addToDocumentPart(sf.createRefCode().toString());
            this.eventBuilder.addToDocumentPart(valueType.getQuoteChar());
            this.currentTus.addAll(events.stream().filter(e -> e.getEventType() == EventType.TEXT_UNIT).map(e -> e.getTextUnit()).collect(Collectors.toList()));
        }
    }

    @Override
    public void handleObjectStart() {
        this.eventBuilder.startGroup(new GenericSkeleton("{"), "Json Object Start");
        this.keyNames.push(new KeyAndType(this.currentKeyName, this.currentKeyType));
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
    }

    @Override
    public void handleObjectEnd() {
        if (!this.currentTus.isEmpty()) {
            for (ITextUnit tu : this.currentTus) {
                if (this.currentId != null) {
                    tu.setName(this.currentId);
                }
                if (this.notes != null) {
                    tu.setAnnotation(this.notes);
                }
                if (this.currentGenericMeta.isEmpty()) continue;
                GenericAnnotation a = new GenericAnnotation("misc-metadata");
                for (MetaData metaData : this.currentGenericMeta) {
                    a.setString(metaData.name, metaData.value);
                }
                GenericAnnotation.addAnnotation(tu, a);
            }
        }
        this.notes = null;
        this.currentId = null;
        this.currentId = null;
        this.currentId = null;
        this.currentGenericMeta.clear();
        this.currentTus.clear();
        this.eventBuilder.endGroup(new GenericSkeleton("}"));
        this.keyNames.pop();
    }

    @Override
    public void handleListStart() {
        this.eventBuilder.startGroup(new GenericSkeleton("["), "Json List Start");
        this.keyNames.push(new KeyAndType(this.currentKeyName, this.currentKeyType));
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
    }

    @Override
    public void handleListEnd() {
        this.eventBuilder.endGroup(new GenericSkeleton("]"));
        this.keyNames.pop();
    }

    @Override
    public void handleSeparator(String separator) {
        this.eventBuilder.addDocumentPart(separator);
    }

    private String buildKeyPath(String key) {
        StringBuilder keyPath = new StringBuilder();
        if (!this.params.getUseFullKeyPath()) {
            if (!this.keyNames.isEmpty() && this.keyNames.peek().type == JsonKeyTypes.LIST) {
                return this.keyNames.peek().name;
            }
            return key;
        }
        if (!this.keyNames.isEmpty()) {
            ListIterator it = this.keyNames.listIterator();
            while (it.hasNext()) {
                KeyAndType k = (KeyAndType)it.next();
                if (k == null || k.name == null) continue;
                keyPath.append("/").append(k.name);
            }
        }
        if (key != null && !key.isEmpty()) {
            keyPath.append("/").append(key);
        }
        if (!this.params.getUseLeadingSlashOnKeyPath() && keyPath.charAt(0) == '/') {
            keyPath.deleteCharAt(0);
        }
        return keyPath.toString();
    }

    private static class MetaData {
        String name;
        String value;

        public MetaData(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class KeyAndType {
        String name;
        JsonKeyTypes type;

        public KeyAndType(String name, JsonKeyTypes type) {
            this.name = name;
            this.type = type;
        }
    }
}

