/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.Spread;
import net.sf.okapi.filters.idml.ZipInput;

class SpreadParser {
    private final ZipInput<XMLEventReader> zipInputReader;
    private final QName spreadName;
    private final XMLEventFactory eventFactory;
    private final String activeLayerId;

    SpreadParser(ZipInput<XMLEventReader> zipInputReader, QName spreadName, XMLEventFactory eventFactory, String activeLayerId) {
        this.zipInputReader = zipInputReader;
        this.spreadName = spreadName;
        this.eventFactory = eventFactory;
        this.activeLayerId = activeLayerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Spread parse(ZipEntry entry) throws XMLStreamException, IOException {
        XMLEventReader eventReader = null;
        Spread.SpreadBuilder spreadBuilder = new Spread.SpreadBuilder().setActiveLayerId(this.activeLayerId);
        try {
            eventReader = this.zipInputReader.of(entry);
            while (eventReader.hasNext()) {
                StartElement element;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !this.spreadName.equals((element = event.asStartElement()).getName())) continue;
                spreadBuilder = this.parseSpread(element, eventReader, spreadBuilder);
                break;
            }
        }
        finally {
            if (null != eventReader) {
                eventReader.close();
            }
        }
        return spreadBuilder.build();
    }

    private Spread.SpreadBuilder parseSpread(StartElement startElement, XMLEventReader eventReader, Spread.SpreadBuilder spreadBuilder) throws XMLStreamException {
        spreadBuilder.setId(startElement.getAttributeByName(ParsingIdioms.SELF).getValue());
        spreadBuilder.setTransformation(startElement.getAttributeByName(ParsingIdioms.ITEM_TRANSFORM).getValue());
        ParsingIdioms.parseSpreadItems(startElement, eventReader, this.eventFactory, spreadBuilder);
        return spreadBuilder;
    }
}

