/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.connectors.google.QueryResultBuilder;
import net.sf.okapi.connectors.google.TranslationResponse;
import net.sf.okapi.lib.translation.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FragmentQueryResultBuilder
extends QueryResultBuilder<TextFragment> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private QueryUtil util = new QueryUtil();

    FragmentQueryResultBuilder(GoogleMTv2Parameters params, String name, int weight) {
        super(params, name, weight);
    }

    @Override
    QueryResult createDummyResponse(TextFragment sourceContent) {
        QueryResult qr = new QueryResult();
        qr.setFuzzyScore(0);
        qr.setCombinedScore(0);
        qr.weight = this.weight;
        qr.origin = this.name;
        qr.matchType = MatchType.MT;
        qr.source = sourceContent;
        qr.target = sourceContent.clone();
        qr.setQuality(QueryResult.QUALITY_UNDEFINED);
        return qr;
    }

    @Override
    List<QueryResult> convertResponses(List<TranslationResponse> responses, TextFragment frag) {
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        for (TranslationResponse response : responses) {
            QueryResult qr = this.createQueryResult(response);
            try {
                qr.source = response.getSource() == null ? frag : this.makeFragment(response.getSource(), frag);
                qr.target = this.makeFragment(response.getTarget(), frag);
            }
            catch (InvalidContentException e) {
                this.logger.error("This MT candidate will be ignored.\n{}\n{}", (Object)frag.toString(), (Object)e.getMessage());
                qr = this.createDummyResponse(frag);
            }
            results.add(qr);
        }
        return results;
    }

    private TextFragment makeFragment(String codedHtml, TextFragment sourceFragment) {
        return sourceFragment.hasCode() ? new TextFragment(this.util.fromCodedHTML(codedHtml, sourceFragment, false), sourceFragment.getClonedCodes()) : new TextFragment(this.util.fromCodedHTML(codedHtml, sourceFragment, false));
    }
}

