/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.common.Util;

public class ConfigurationString {
    private static final String STARTGROUP = "beginGroup";
    private static final String ENDGROUP = "endGroup";
    private StringBuilder data;

    public ConfigurationString() {
        this.reset();
    }

    public ConfigurationString(String data) {
        this.fromString(data);
    }

    public void fromString(String data) {
        if (data != null) {
            this.data = new StringBuilder(this.prependMarker(data.replace('\r', '\n')));
        } else {
            this.reset();
        }
    }

    public void reset() {
        this.data = new StringBuilder();
        this.data.append("\n");
    }

    public String toString() {
        String tmp = this.data.toString().replaceAll("\n\n", "\n");
        return tmp.trim();
    }

    public void set(String name, String value) {
        if (value != null) {
            value = String.format("%s=%s\n", name, this.escape(value));
        }
        String tmpName = "\n" + name + "=";
        int pos1 = this.data.toString().indexOf(tmpName);
        if (pos1 < 0) {
            if (value != null) {
                this.data.append(value);
            }
            return;
        }
        int pos2 = this.data.toString().indexOf("\n", pos1 + 1);
        if (pos2 < 0) {
            pos2 = pos1;
        }
        this.data.delete(pos1 + 1, pos2);
        if (value != null) {
            this.data.insert(pos1 + 1, value);
        }
    }

    public void add(String name, String value) {
        if (value == null) {
            this.data.append(String.format("%s=%s\n", name, ""));
        } else {
            this.data.append(String.format("%s=%s\n", name, this.escape(value)));
        }
    }

    public void add(String name, boolean value) {
        this.data.append(String.format("%s=%d\n", name, value ? 1 : 0));
    }

    public void add(String name, int value) {
        this.data.append(String.format("%s=%d\n", name, value));
    }

    public void add(String name, char value) {
        this.data.append(String.format("%s=%c\n", name, Character.valueOf(value)));
    }

    public void addGroup(String name, String value) {
        this.data.append(String.format("%s=%s\n%s\n%s\n", STARTGROUP, name, this.prependMarker(value.replace('\r', '\n')), ENDGROUP));
    }

    public String get(String name, String defaultValue) {
        String tmpName = "\n" + name + "=";
        int pos1 = this.data.toString().indexOf(tmpName);
        if (pos1 < 0) {
            return defaultValue;
        }
        int pos2 = this.data.toString().indexOf("\n", pos1 += tmpName.length());
        if (pos2 < 0) {
            return defaultValue;
        }
        return this.unescape(this.data.toString().substring(pos1, pos2));
    }

    public boolean get(String name, boolean defaultValue) {
        String sTmp = this.get(name, null);
        if (sTmp == null) {
            return defaultValue;
        }
        return sTmp.equals("1");
    }

    public int get(String name, int defaultValue) {
        String tmp = this.get(name, null);
        if (tmp == null || tmp.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(tmp);
    }

    public char get(String name, char defaultValue) {
        String tmp = this.get(name, null);
        if (tmp == null || tmp.length() == 0) {
            return defaultValue;
        }
        return tmp.charAt(0);
    }

    public String getGroup(String name, String defaultValue) {
        String tmpName = "\nbeginGroup" + name + "=";
        int pos1 = this.data.toString().indexOf(tmpName);
        if (pos1 < 0) {
            return defaultValue;
        }
        int pos2 = this.data.toString().indexOf("\n", pos1 += tmpName.length());
        if (pos2 < 0) {
            return defaultValue;
        }
        return this.data.toString().substring(pos1, pos2);
    }

    public Map<String, String> toMap() {
        String[] pairs;
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
        String tmp = this.toString();
        if (Util.isEmpty(tmp)) {
            return table;
        }
        for (String pair : pairs = tmp.split("\n", 0)) {
            String[] keyvalue = pair.split("=");
            table.put(keyvalue[0], keyvalue.length > 1 ? keyvalue[1] : "");
        }
        return table;
    }

    private String prependMarker(String data) {
        if (data == null) {
            return data;
        }
        if (data.length() == 0) {
            return "\n";
        }
        if (data.charAt(0) != '\n') {
            return "\n" + data;
        }
        return data;
    }

    private String escape(String text) {
        String escapedText = text.replace("\r", "{0xD}");
        return escapedText.replace("\n", "{0xA}");
    }

    private String unescape(String text) {
        String escapedText = text.replace("{0xD}", "\r");
        return escapedText.replace("{0xA}", "\n");
    }
}

