/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xmlanalysis;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.steps.xmlanalysis.Parameters;
import net.sf.okapi.steps.xmlanalysis.XMLAnalyzer;

@UsingParameters(value=Parameters.class)
public class XMLAnalysisStep
extends BasePipelineStep {
    private XMLAnalyzer xmlan = new XMLAnalyzer();

    @Override
    public String getDescription() {
        return "Generate an analysis report of a set of XML documents. Expects: raw document. Sends back: raw document.";
    }

    @Override
    public String getName() {
        return "XML Analysis";
    }

    @Override
    public IParameters getParameters() {
        return this.xmlan.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.xmlan.setParameters((Parameters)params);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.xmlan.reset();
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.xmlan.generateOutput();
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        this.xmlan.analyzeDocument(event.getRawDocument());
        return event;
    }

    protected XMLAnalyzer getAnalyzer() {
        return this.xmlan;
    }
}

