/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.common;

import net.sf.okapi.common.Range;
import net.sf.okapi.steps.tokenization.common.Lexem;
import net.sf.okapi.steps.tokenization.tokens.Tokens;

public class Token {
    private int tokenId;
    private Lexem lexem;
    private int score;

    public Token(int tokenId, Lexem lexem, int score) {
        this.tokenId = tokenId;
        this.lexem = lexem;
        this.setScore(score);
    }

    public int getTokenId() {
        return this.tokenId;
    }

    public Lexem getLexem() {
        return this.lexem;
    }

    public Range getRange() {
        if (this.lexem == null) {
            return new Range(0, 0);
        }
        return this.lexem.getRange();
    }

    public int getScore() {
        return this.score;
    }

    public int getLexerId() {
        if (this.lexem == null) {
            return 0;
        }
        return this.lexem.getLexerId();
    }

    public int getLexemId() {
        if (this.lexem == null) {
            return 0;
        }
        return this.lexem.getId();
    }

    public String getValue() {
        if (this.lexem == null) {
            return "";
        }
        return this.lexem.getValue();
    }

    public String getName() {
        return Tokens.getTokenName(this.tokenId);
    }

    public String getDescription() {
        return Tokens.getTokenDescription(this.tokenId);
    }

    public String toString() {
        return String.format("%-15s\t%d\t%3d%%\t%s", this.getName(), this.tokenId, this.score, this.lexem.toString());
    }

    public void setScore(int score) {
        if (score < 0) {
            score = 0;
        }
        if (score > 100) {
            score = 100;
        }
        this.score = score;
    }

    public boolean isImmutable() {
        if (this.lexem == null) {
            return false;
        }
        return this.lexem.isImmutable();
    }

    public void setImmutable(boolean immutable) {
        if (this.lexem == null) {
            return;
        }
        this.lexem.setImmutable(immutable);
    }

    public void setDeleted(boolean deleted) {
        if (this.lexem == null) {
            return;
        }
        this.lexem.setDeleted(deleted);
    }

    public boolean isDeleted() {
        if (this.lexem == null) {
            return false;
        }
        return this.lexem.isDeleted();
    }

    public void delete() {
        this.setDeleted(true);
    }

    public void undelete() {
        this.setDeleted(false);
    }
}

